"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaxSnapshotsField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MaxSnapshotsField = ({
  isInvalid,
  error,
  defaultValue,
  updateSettings
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.commonFields.maxSnapshotBytesTitle",
      defaultMessage: "Max snapshot bytes per second"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.commonFields.maxSnapshotBytesDescription",
      defaultMessage: "Maximum rate for creating snapshots for each node."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.commonFields.maxSnapshotBytesLabel",
      defaultMessage: "Max snapshot bytes per second"
    }),
    fullWidth: true,
    isInvalid: isInvalid,
    error: error,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.commonFields.maxSnapshotBytesHelpText",
      defaultMessage: "Accepts byte size units, such as {example1}, {example2}, {example3}, or {example4}. Defaults to {defaultSize} per second.",
      values: {
        example1: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "1g"),
        example2: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "10mb"),
        example3: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "5k"),
        example4: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "1024B"),
        defaultSize: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "40mb")
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: isInvalid,
    defaultValue: defaultValue,
    fullWidth: true,
    onChange: e => updateSettings('maxSnapshotBytesPerSec', e.target.value),
    "data-test-subj": "maxSnapshotBytesInput"
  })));
};
exports.MaxSnapshotsField = MaxSnapshotsField;