"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSLOTransformTemplate = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSLOTransformTemplate = (transformId, description, source, destination, groupBy = {}, aggregations = {}, settings, slo) => {
  const formattedSource = buildSourceWithFilters(source, slo);
  return {
    transform_id: transformId,
    description,
    source: formattedSource,
    frequency: settings.frequency,
    dest: destination,
    settings: {
      deduce_mappings: false,
      unattended: true
    },
    sync: {
      time: {
        field: settings.sync_field,
        delay: settings.sync_delay
      }
    },
    pivot: {
      group_by: groupBy,
      aggregations
    },
    defer_validation: true,
    _meta: {
      version: _constants.SLO_RESOURCES_VERSION,
      managed: true,
      managed_by: 'observability'
    }
  };
};
exports.getSLOTransformTemplate = getSLOTransformTemplate;
const buildGroupingFilters = slo => {
  // build exists filters for each groupBy field to make sure the field exists
  const groups = [slo.groupBy].flat().filter(group => !!group && group !== _sloSchema.ALL_VALUE);
  return groups.map(group => ({
    exists: {
      field: group
    }
  }));
};
const buildSourceWithFilters = (source, slo) => {
  var _source$query, _source$query$bool, _source$query2;
  const groupingFilters = buildGroupingFilters(slo);
  const sourceFilters = [(_source$query = source.query) === null || _source$query === void 0 ? void 0 : (_source$query$bool = _source$query.bool) === null || _source$query$bool === void 0 ? void 0 : _source$query$bool.filter].flat() || [];
  return {
    ...source,
    query: {
      ...source.query,
      bool: {
        ...((_source$query2 = source.query) === null || _source$query2 === void 0 ? void 0 : _source$query2.bool),
        filter: [...sourceFilters, ...groupingFilters]
      }
    }
  };
};