"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APMAvailabilityAlertDetails = APMAvailabilityAlertDetails;
exports.APMLatencyAlertDetails = APMLatencyAlertDetails;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _embeddable_root = require("./embeddable_root");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function APMLatencyAlertDetails({
  slo,
  dataTimeRange,
  alert,
  rule
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "overviewSection"
  }, /*#__PURE__*/_react.default.createElement(_embeddable_root.APMEmbeddableRoot, {
    slo: slo,
    dataTimeRange: dataTimeRange,
    embeddableId: 'APM_ALERTING_LATENCY_CHART_EMBEDDABLE',
    alert: alert,
    rule: rule
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_embeddable_root.APMEmbeddableRoot, {
    slo: slo,
    dataTimeRange: dataTimeRange,
    embeddableId: 'APM_ALERTING_THROUGHPUT_CHART_EMBEDDABLE',
    alert: alert,
    rule: rule
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_embeddable_root.APMEmbeddableRoot, {
    slo: slo,
    dataTimeRange: dataTimeRange,
    embeddableId: 'APM_ALERTING_FAILED_TRANSACTIONS_CHART_EMBEDDABLE',
    alert: alert,
    rule: rule
  }))));
}
function APMAvailabilityAlertDetails({
  slo,
  dataTimeRange,
  alert,
  rule
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "overviewSection"
  }, /*#__PURE__*/_react.default.createElement(_embeddable_root.APMEmbeddableRoot, {
    slo: slo,
    dataTimeRange: dataTimeRange,
    embeddableId: 'APM_ALERTING_FAILED_TRANSACTIONS_CHART_EMBEDDABLE',
    alert: alert,
    rule: rule
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_embeddable_root.APMEmbeddableRoot, {
    slo: slo,
    dataTimeRange: dataTimeRange,
    embeddableId: 'APM_ALERTING_THROUGHPUT_CHART_EMBEDDABLE',
    alert: alert,
    rule: rule
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_embeddable_root.APMEmbeddableRoot, {
    slo: slo,
    dataTimeRange: dataTimeRange,
    embeddableId: 'APM_ALERTING_LATENCY_CHART_EMBEDDABLE',
    alert: alert,
    rule: rule
  }))));
}