"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanelAccordion = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _detail_panel_description_list = require("../detail_panel_description_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * An accordion section in session view detail panel.
 */
const DetailPanelAccordion = ({
  id,
  listItems,
  title,
  tooltipContent,
  extraActionTitle,
  onExtraActionClick,
  children,
  initialIsOpen = false
}) => {
  const styles = (0, _styles.useStyles)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: id,
    arrowDisplay: "right",
    initialIsOpen: initialIsOpen,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      css: styles.accordionButton
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("span", null, title)), tooltipContent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": "sessionView:detail-panel-accordion-tooltip"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: tooltipContent
    })))
    // extraAction={
    //   extraActionTitle ? (
    //     <EuiButtonEmpty
    //       size="s"
    //       color="primary"
    //       onClick={onExtraActionClick}
    //       data-test-subj="sessionView:detail-panel-accordion-action"
    //     >
    //       {extraActionTitle}
    //     </EuiButtonEmpty>
    //   ) : null
    // }
    ,
    css: styles.accordion,
    "data-test-subj": "sessionView:detail-panel-accordion"
  }, /*#__PURE__*/_react.default.createElement(_detail_panel_description_list.DetailPanelDescriptionList, {
    listItems: listItems
  }), children);
};
exports.DetailPanelAccordion = DetailPanelAccordion;