"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isApprovedListType = exports.computeMedian = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const computeMedian = arr => {
  if (!arr.length) return 0;
  const sorted = [...arr].sort((a, b) => a - b);
  const mid = Math.floor(sorted.length / 2);
  if (sorted.length % 2 === 0) {
    return (sorted[mid - 1] + sorted[mid]) / 2;
  } else {
    return sorted[mid];
  }
};
exports.computeMedian = computeMedian;
const isApprovedListType = listType => {
  return _types.LIST_TYPES.includes(listType);
};
exports.isApprovedListType = isApprovedListType;