"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildKpiRiskScoreQuery = void 0;
var _types = require("../../../../../../common/entity_analytics/types");
var _search_strategy = require("../../../../../../common/search_strategy");
var _build_query = require("../../../../../utils/build_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildKpiRiskScoreQuery = ({
  defaultIndex,
  filterQuery,
  entity,
  timerange
}) => {
  const filter = [...(0, _build_query.createQueryFilterClauses)(filterQuery)];
  if (timerange) {
    filter.push({
      range: {
        '@timestamp': {
          gte: timerange.from,
          lte: timerange.to,
          format: 'strict_date_optional_time'
        }
      }
    });
  }
  const dslQuery = {
    index: defaultIndex,
    allow_no_indices: false,
    ignore_unavailable: true,
    track_total_hits: false,
    aggs: {
      risk: {
        terms: {
          field: _search_strategy.EntityTypeToLevelField[entity]
        },
        aggs: {
          unique_entries: {
            cardinality: {
              field: _types.EntityTypeToIdentifierField[entity]
            }
          }
        }
      }
    },
    query: {
      bool: {
        filter
      }
    },
    size: 0
  };
  return dslQuery;
};
exports.buildKpiRiskScoreQuery = buildKpiRiskScoreQuery;