"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExceptionsPreImportHandler = void 0;
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _stringify = require("../../../endpoint/utils/stringify");
var _constants = require("../../../../common/endpoint/service/artifacts/constants");
var _errors = require("../validators/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getExceptionsPreImportHandler = endpointAppContextService => {
  const logger = endpointAppContextService.createLogger('listsPreImportExtensionPoint');
  return async ({
    data
  }) => {
    const hasEndpointArtifactListOrListItems = [...data.lists, ...data.items].some(item => {
      if ('list_id' in item) {
        return _constants.ALL_ENDPOINT_ARTIFACT_LIST_IDS.includes(item.list_id);
      }
      return false;
    });
    if (hasEndpointArtifactListOrListItems) {
      throw new _errors.EndpointArtifactExceptionValidationError('Import is not supported for Endpoint artifact exceptions');
    }

    // Temporary Work-around:
    // v9.1.0 introduced support for spaces, which also now requires that each endpoint exception
    // have the `global` tag, or else they will not be returned via API. Since Endpoint
    // Exceptions continue to be global only in v9.1, we add the global tag to them here if it is
    // missing
    const adjustedImportItems = [];
    for (const item of data.items) {
      var _item$tags;
      if (!(item instanceof Error) && item.list_id === _securitysolutionListConstants.ENDPOINT_LIST_ID && ((_item$tags = item.tags) === null || _item$tags === void 0 ? void 0 : _item$tags.includes(_constants.GLOBAL_ARTIFACT_TAG)) === false) {
        var _item$tags2;
        item.tags = (_item$tags2 = item.tags) !== null && _item$tags2 !== void 0 ? _item$tags2 : [];
        item.tags.push(_constants.GLOBAL_ARTIFACT_TAG);
        adjustedImportItems.push(item);
      }
    }
    if (adjustedImportItems.length > 0) {
      logger.debug(`The following Endpoint Exceptions item imports were adjusted to include the Global artifact tag:
${(0, _stringify.stringify)(adjustedImportItems)}`);
    }
    return data;
  };
};
exports.getExceptionsPreImportHandler = getExceptionsPreImportHandler;