"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemRuleMigrationsResourceGetRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _constants = require("../../../../../../common/siem_migrations/constants");
var _rule_migration = require("../../../../../../common/siem_migrations/model/api/rules/rule_migration.gen");
var _audit = require("../util/audit");
var _authz = require("../util/authz");
var _with_license = require("../util/with_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemRuleMigrationsResourceGetRoute = (router, logger) => {
  router.versioned.get({
    path: _constants.SIEM_RULE_MIGRATION_RESOURCES_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_migration.GetRuleMigrationResourcesRequestParams),
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_migration.GetRuleMigrationResourcesRequestQuery)
      }
    }
  }, (0, _with_license.withLicense)(async (context, req, res) => {
    const migrationId = req.params.migration_id;
    const {
      type,
      names,
      from,
      size
    } = req.query;
    const siemMigrationAuditLogger = new _audit.SiemMigrationAuditLogger(context.securitySolution);
    try {
      const ctx = await context.resolve(['securitySolution']);
      const ruleMigrationsClient = ctx.securitySolution.getSiemRuleMigrationsClient();
      const options = {
        filters: {
          type,
          names
        },
        from,
        size
      };
      const resources = await ruleMigrationsClient.data.resources.get(migrationId, options);
      await siemMigrationAuditLogger.logGetResources({
        migrationId
      });
      return res.ok({
        body: resources
      });
    } catch (error) {
      logger.error(error);
      await siemMigrationAuditLogger.logGetResources({
        migrationId,
        error
      });
      return res.badRequest({
        body: error.message
      });
    }
  }));
};
exports.registerSiemRuleMigrationsResourceGetRoute = registerSiemRuleMigrationsResourceGetRoute;