"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.disablePrivilegeMonitoringEngineRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
var _assert_advanced_setting_enabled = require("../../utils/assert_advanced_setting_enabled");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const disablePrivilegeMonitoringEngineRoute = (router, logger, config) => {
  router.versioned.post({
    access: 'public',
    path: '/api/entity_analytics/monitoring/engine/disable',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    },
    options: {
      availability: {
        since: '9.1.0',
        stability: 'stable'
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {}
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const secSol = await context.securitySolution;
    await (0, _assert_advanced_setting_enabled.assertAdvancedSettingsEnabled)(await context.core, _constants.ENABLE_PRIVILEGED_USER_MONITORING_SETTING);
    try {
      const body = await secSol.getPrivilegeMonitoringDataClient().disable();
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error disabling privilege monitoring engine: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.disablePrivilegeMonitoringEngineRoute = disablePrivilegeMonitoringEngineRoute;