"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPrivilegeMonitoringIndicesRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _create_index = require("../../../../../common/api/entity_analytics/monitoring/create_index.gen");
var _constants = require("../../../../../common/constants");
var _assert_advanced_setting_enabled = require("../../utils/assert_advanced_setting_enabled");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPrivilegeMonitoringIndicesRoute = (router, logger) => {
  router.versioned.put({
    access: 'public',
    path: '/api/entity_analytics/monitoring/privileges/indices',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_create_index.CreatePrivilegesImportIndexRequestBody)
      }
    }
  }, async (context, request, response) => {
    const secSol = await context.securitySolution;
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const indexName = request.body.name;
    const indexMode = request.body.mode;
    await (0, _assert_advanced_setting_enabled.assertAdvancedSettingsEnabled)(await context.core, _constants.ENABLE_PRIVILEGED_USER_MONITORING_SETTING);
    try {
      await secSol.getPrivilegeMonitoringDataClient().createPrivilegesImportIndex(indexName, indexMode);
      return response.ok();
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error creating privilege monitoring indices: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.createPrivilegeMonitoringIndicesRoute = createPrivilegeMonitoringIndicesRoute;