"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indicatorMatchExecutor = void 0;
var _create_threat_signals = require("./threat_mapping/create_threat_signals");
var _with_security_span = require("../../../../utils/with_security_span");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const indicatorMatchExecutor = async ({
  sharedParams,
  services,
  eventsTelemetry,
  wrapSuppressedHits,
  licensing,
  scheduleNotificationResponseActionsService
}) => {
  return (0, _with_security_span.withSecuritySpan)('indicatorMatchExecutor', async () => {
    return (0, _create_threat_signals.createThreatSignals)({
      sharedParams,
      eventsTelemetry,
      services,
      wrapSuppressedHits,
      licensing,
      scheduleNotificationResponseActionsService
    });
  });
};
exports.indicatorMatchExecutor = indicatorMatchExecutor;