"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRuleImportError = exports.isRuleConflictError = exports.createRuleImportErrorObject = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Generic interface representing a server-side failure during rule import.
 * Used by utilities that import rules or related entities.
 *
 * NOTE that this does not inherit from Error
 */

const createRuleImportErrorObject = ({
  ruleId,
  message,
  type
}) => ({
  error: {
    ruleId,
    message,
    type: type !== null && type !== void 0 ? type : 'unknown'
  }
});
exports.createRuleImportErrorObject = createRuleImportErrorObject;
const isRuleImportError = obj => (0, _lodash.has)(obj, 'error') && (0, _lodash.has)(obj, 'error.ruleId') && (0, _lodash.has)(obj, 'error.type') && (0, _lodash.has)(obj, 'error.message');
exports.isRuleImportError = isRuleImportError;
const isRuleConflictError = error => error.error.type === 'conflict';
exports.isRuleConflictError = isRuleConflictError;