"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.forceTargetVersionDiffAlgorithm = void 0;
var _prebuilt_rules = require("../../../../../../../../common/api/detection_engine/prebuilt_rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Diff algorithm forcing target version. Useful for special fields like `version`.
 */
const forceTargetVersionDiffAlgorithm = versions => {
  const {
    base_version: baseVersion,
    current_version: currentVersion,
    target_version: targetVersion
  } = versions;
  const hasBaseVersion = baseVersion !== _prebuilt_rules.MissingVersion;
  const hasUpdate = targetVersion !== currentVersion;
  return {
    has_base_version: hasBaseVersion,
    base_version: hasBaseVersion ? baseVersion : undefined,
    current_version: currentVersion,
    target_version: targetVersion,
    merged_version: targetVersion,
    merge_outcome: _prebuilt_rules.ThreeWayMergeOutcome.Target,
    diff_outcome: (0, _prebuilt_rules.determineDiffOutcome)(baseVersion, currentVersion, targetVersion),
    has_update: hasUpdate,
    conflict: _prebuilt_rules.ThreeWayDiffConflict.NONE
  };
};
exports.forceTargetVersionDiffAlgorithm = forceTargetVersionDiffAlgorithm;