"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggregatePrebuiltRuleErrors = aggregatePrebuiltRuleErrors;
var _error_helpers = require("../../../../utils/error_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function aggregatePrebuiltRuleErrors(errors) {
  const errorsByMessage = {};
  errors.forEach(({
    error,
    item
  }) => {
    const message = (0, _error_helpers.getErrorMessage)(error);
    const statusCode = (0, _error_helpers.getErrorStatusCode)(error);
    const failedRule = {
      rule_id: item.rule_id,
      name: item.name
    };
    if (errorsByMessage[message]) {
      errorsByMessage[message].rules.push(failedRule);
    } else {
      errorsByMessage[message] = {
        message,
        status_code: statusCode,
        rules: [failedRule]
      };
    }
  });
  return Object.values(errorsByMessage);
}