"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createModifiedPrebuiltRuleAssets = void 0;
var _lodash = require("lodash");
var _utils = require("../../../../../../common/detection_engine/rule_management/utils");
var _with_security_span = require("../../../../../utils/with_security_span");
var _detection_engine = require("../../../../../../common/api/detection_engine");
var _prebuilt_rules = require("../../../../../../common/api/detection_engine/prebuilt_rules");
var _convert_rule_to_diffable = require("../../../../../../common/detection_engine/prebuilt_rules/diff/convert_rule_to_diffable");
var _assert_pick_version_is_target = require("./assert_pick_version_is_target");
var _create_props_to_rule_type_map = require("./create_props_to_rule_type_map");
var _calculate_three_way_rule_fields_diff = require("../../logic/diff/calculation/calculate_three_way_rule_fields_diff");
var _convert_prebuilt_rule_asset_to_rule_response = require("../../../rule_management/logic/detection_rules_client/converters/convert_prebuilt_rule_asset_to_rule_response");
var _get_value_for_field = require("./get_value_for_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createModifiedPrebuiltRuleAssets = ({
  upgradeableRules,
  requestBody,
  defaultPickVersion
}) => {
  return (0, _with_security_span.withSecuritySpanSync)(createModifiedPrebuiltRuleAssets.name, () => {
    const {
      pick_version: globalPickVersion = defaultPickVersion,
      mode,
      on_conflict: onConflict
    } = requestBody;
    const {
      modifiedPrebuiltRuleAssets,
      processingErrors,
      ruleUpgradeContexts
    } = upgradeableRules.reduce((processedRules, upgradeableRule) => {
      const targetRuleType = upgradeableRule.target.type;
      const ruleId = upgradeableRule.target.rule_id;
      const fieldNames = _create_props_to_rule_type_map.FIELD_NAMES_BY_RULE_TYPE_MAP.get(targetRuleType);
      try {
        if (fieldNames === undefined) {
          throw new Error(`Unexpected rule type: ${targetRuleType}`);
        }
        const {
          current,
          target
        } = upgradeableRule;
        if (current.type !== target.type) {
          (0, _assert_pick_version_is_target.assertPickVersionIsTarget)({
            ruleId,
            requestBody
          });
        }
        const isCustomized = (0, _utils.isRuleCustomized)(current);
        const calculatedRuleDiff = (0, _calculate_three_way_rule_fields_diff.calculateThreeWayRuleFieldsDiff)({
          base_version: upgradeableRule.base ? (0, _convert_rule_to_diffable.convertRuleToDiffable)((0, _convert_prebuilt_rule_asset_to_rule_response.convertPrebuiltRuleAssetToRuleResponse)(upgradeableRule.base)) : _detection_engine.MissingVersion,
          current_version: (0, _convert_rule_to_diffable.convertRuleToDiffable)(upgradeableRule.current),
          target_version: (0, _convert_rule_to_diffable.convertRuleToDiffable)((0, _convert_prebuilt_rule_asset_to_rule_response.convertPrebuiltRuleAssetToRuleResponse)(upgradeableRule.target))
        }, isCustomized);
        if (mode === 'ALL_RULES' && globalPickVersion === 'MERGED') {
          const fieldsWithConflicts = Object.keys(getFieldsDiffConflicts(calculatedRuleDiff, onConflict));
          if (fieldsWithConflicts.length > 0) {
            // If the mode is ALL_RULES, no fields can be overriden to any other pick_version
            // than "MERGED", so throw an error for the fields that have conflicts.
            throw new Error(`Merge conflicts found in rule '${ruleId}' for fields: ${fieldsWithConflicts.join(', ')}. Please resolve the conflict manually or choose another value for 'pick_version'`);
          }
        }
        const modifiedPrebuiltRuleAsset = createModifiedPrebuiltRuleAsset({
          upgradeableRule,
          fieldNames,
          requestBody,
          globalPickVersion,
          calculatedRuleDiff
        });
        processedRules.modifiedPrebuiltRuleAssets.push(modifiedPrebuiltRuleAsset);
        processedRules.ruleUpgradeContexts.push({
          ruleId,
          ruleName: upgradeableRule.target.name,
          hasBaseVersion: !!upgradeableRule.base,
          isCustomized,
          fieldsDiff: calculatedRuleDiff
        });
        return processedRules;
      } catch (err) {
        processedRules.processingErrors.push({
          error: err,
          item: {
            rule_id: ruleId
          }
        });
        return processedRules;
      }
    }, {
      modifiedPrebuiltRuleAssets: [],
      processingErrors: [],
      ruleUpgradeContexts: []
    });
    return {
      modifiedPrebuiltRuleAssets,
      processingErrors,
      ruleUpgradeContexts
    };
  });
};
exports.createModifiedPrebuiltRuleAssets = createModifiedPrebuiltRuleAssets;
function createModifiedPrebuiltRuleAsset({
  upgradeableRule,
  fieldNames,
  globalPickVersion,
  requestBody,
  calculatedRuleDiff
}) {
  const modifiedPrebuiltRuleAsset = {};
  for (const fieldName of fieldNames) {
    modifiedPrebuiltRuleAsset[fieldName] = (0, _get_value_for_field.getValueForField)({
      fieldName,
      upgradeableRule,
      globalPickVersion,
      requestBody,
      ruleFieldsDiff: calculatedRuleDiff
    });
  }
  return modifiedPrebuiltRuleAsset;
}
const getFieldsDiffConflicts = (ruleFieldsDiff, onConflict) => (0, _lodash.pickBy)(ruleFieldsDiff, diff => onConflict === _prebuilt_rules.UpgradeConflictResolutionEnum.UPGRADE_SOLVABLE ? diff.conflict !== 'NONE' && diff.conflict !== 'SOLVABLE' : diff.conflict !== 'NONE');