"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorFieldsTable = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _field_value = require("../common/field_value");
var _indicator_value_actions = require("./indicator_value_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicatorFieldsTable = ({
  fields,
  indicator,
  'data-test-subj': dataTestSubj
}) => {
  const columns = (0, _react.useMemo)(() => [{
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.threatIntelligence.indicator.fieldsTable.fieldColumnLabel",
      defaultMessage: "Field"
    }),
    render: field => field
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.threatIntelligence.indicator.fieldsTable.valueColumnLabel",
      defaultMessage: "Value"
    }),
    render: field => /*#__PURE__*/_react.default.createElement(_field_value.IndicatorFieldValue, {
      indicator: indicator,
      field: field
    })
  }, {
    actions: [{
      render: field => /*#__PURE__*/_react.default.createElement(_indicator_value_actions.IndicatorValueActions, {
        field: field,
        indicator: indicator,
        "data-test-subj": dataTestSubj
      }),
      width: '72px'
    }]
  }
  // @ts-expect-error - EuiBasicTable wants an array of objects, but will accept strings if coerced
  ], [indicator, dataTestSubj]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable
  // @ts-expect-error - EuiInMemoryTable wants an array of objects, but will accept strings if coerced
  , {
    items: fields.sort()
    // @ts-expect-error - EuiInMemoryTable wants an array of objects, but will accept strings if coerced
    ,
    columns: columns,
    sorting: true,
    "data-test-subj": dataTestSubj
  });
};
exports.IndicatorFieldsTable = IndicatorFieldsTable;