"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoMatchDataMessage = exports.MissingPatternsMessage = exports.DeprecatedMessage = exports.CurrentPatternsMessage = exports.BadCurrentPatternsMessage = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _timeline = require("../../../common/api/timeline");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CurrentPatternsMessage = ({
  activePatterns,
  deadPatterns,
  selectedPatterns,
  timelineType
}) => {
  const tooltip = (0, _react.useMemo)(() => deadPatterns.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement(NoMatchDataMessage, {
      activePatterns: activePatterns,
      selectedPatterns: selectedPatterns,
      timelineType: timelineType
    }),
    type: "question",
    title: i18n.INACTIVE_PATTERNS
  }) : null, [activePatterns, deadPatterns.length, selectedPatterns, timelineType]);
  if (timelineType === _timeline.TimelineTypeEnum.template) {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "sourcerer-current-patterns-message"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.indexPatterns.timelineTemplate.currentPatterns",
      defaultMessage: "The active index patterns in this timeline template are{tooltip}: {callout}",
      values: {
        tooltip,
        callout: /*#__PURE__*/_react.default.createElement(_helpers.Blockquote, null, activePatterns.join(', '))
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "sourcerer-current-patterns-message"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.indexPatterns.timeline.currentPatterns",
    defaultMessage: "The active index patterns in this timeline are{tooltip}: {callout}",
    values: {
      tooltip,
      callout: /*#__PURE__*/_react.default.createElement(_helpers.Blockquote, null, activePatterns.join(', '))
    }
  }));
};
exports.CurrentPatternsMessage = CurrentPatternsMessage;
const NoMatchDataMessage = ({
  activePatterns,
  selectedPatterns,
  timelineType
}) => {
  const aliases = (0, _react.useMemo)(() => selectedPatterns.filter(p => !activePatterns.includes(p)).join(', '), [activePatterns, selectedPatterns]);
  if (timelineType === _timeline.TimelineTypeEnum.template) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.indexPatterns.timelineTemplate.noMatchData",
      defaultMessage: "The following index patterns are saved to this timeline template but do not match any data streams, indices, or index aliases: {aliases}",
      values: {
        aliases
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.indexPatterns.timeline.noMatchData",
    defaultMessage: "The following index patterns are saved to this timeline but do not match any data streams, indices, or index aliases: {aliases}",
    values: {
      aliases
    }
  });
};
exports.NoMatchDataMessage = NoMatchDataMessage;
const BadCurrentPatternsMessage = ({
  timelineType,
  selectedPatterns
}) => {
  const callout = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_helpers.Blockquote, null, selectedPatterns.join(', ')), [selectedPatterns]);
  if (timelineType === _timeline.TimelineTypeEnum.template) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.indexPatterns.timelineTemplate.currentPatternsBad",
      defaultMessage: "The current index patterns in this timeline template are: {callout}",
      values: {
        callout
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.indexPatterns.timeline.currentPatternsBad",
    defaultMessage: "The current index patterns in this timeline are: {callout}",
    values: {
      callout
    }
  });
};
exports.BadCurrentPatternsMessage = BadCurrentPatternsMessage;
const DeprecatedMessage = ({
  onReset,
  timelineType
}) => {
  if (timelineType === _timeline.TimelineTypeEnum.template) {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "sourcerer-deprecated-message"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.indexPatterns.timelineTemplate.toggleToNewSourcerer",
      defaultMessage: "We have preserved your timeline template by creating a temporary data view. If you'd like to modify your data, we can recreate your temporary data view with the new data view selector. You can also manually select a data view {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: onReset
        }, i18n.TOGGLE_TO_NEW_SOURCERER)
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "sourcerer-deprecated-message"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.indexPatterns.timeline.toggleToNewSourcerer",
    defaultMessage: "We have preserved your timeline by creating a temporary data view. If you'd like to modify your data, we can recreate your temporary data view with the new data view selector. You can also manually select a data view {link}.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: onReset
      }, i18n.TOGGLE_TO_NEW_SOURCERER)
    }
  }));
};
exports.DeprecatedMessage = DeprecatedMessage;
const MissingPatternsMessage = ({
  onReset,
  timelineType
}) => {
  if (timelineType === _timeline.TimelineTypeEnum.template) {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "sourcerer-missing-patterns-message"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.indexPatterns.missingPatterns.timelineTemplate.description",
      defaultMessage: "We have preserved your timeline template by creating a temporary data view. If you'd like to modify your data, we can add the missing index patterns to the Security Data View. You can also manually select a data view {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: onReset
        }, i18n.TOGGLE_TO_NEW_SOURCERER)
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "sourcerer-missing-patterns-message"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.indexPatterns.missingPatterns.timeline.description",
    defaultMessage: "We have preserved your timeline by creating a temporary data view. If you'd like to modify your data, we can add the missing index patterns to the Security Data View. You can also manually select a data view {link}.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: onReset
      }, i18n.TOGGLE_TO_NEW_SOURCERER)
    }
  }));
};
exports.MissingPatternsMessage = MissingPatternsMessage;