"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMissingLookupsListStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_upsert_resources = require("../../../../../../service/hooks/use_upsert_resources");
var i18n = _interopRequireWildcard(require("./translations"));
var _missing_lookups_list = require("./missing_lookups_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMissingLookupsListStep = ({
  status,
  migrationStats,
  missingLookups,
  uploadedLookups,
  addUploadedLookups,
  onCopied
}) => {
  const {
    upsertResources,
    isLoading,
    error
  } = (0, _use_upsert_resources.useUpsertResources)(addUploadedLookups);
  const omitLookup = (0, _react.useCallback)(lookupName => {
    // Saving the lookup with an empty content to omit it.
    // The translation will ignore this lookup and will not cause partial translations.
    upsertResources(migrationStats.id, [{
      type: 'lookup',
      name: lookupName,
      content: ''
    }]);
  }, [upsertResources, migrationStats]);
  const listStepStatus = (0, _react.useMemo)(() => {
    if (isLoading) {
      return 'loading';
    }
    if (error) {
      return 'danger';
    }
    return status;
  }, [isLoading, error, status]);
  return {
    title: i18n.LOOKUPS_DATA_INPUT_COPY_TITLE,
    status: listStepStatus,
    children: /*#__PURE__*/_react.default.createElement(_missing_lookups_list.MissingLookupsList, {
      onCopied: onCopied,
      missingLookups: missingLookups,
      uploadedLookups: uploadedLookups,
      omitLookup: omitLookup
    })
  };
};
exports.useMissingLookupsListStep = useMissingLookupsListStep;