"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkRulesComplete = void 0;
var _common = require("../../../../../../common");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const checkRulesComplete = async ({
  http,
  notifications: {
    toasts
  }
}) => {
  // Check if there are any rules installed and enabled
  try {
    const data = await fetchRuleManagementFilters({
      http,
      query: {
        page: 1,
        per_page: 20,
        sort_field: 'enabled',
        sort_order: 'desc',
        filter: `${_common.ENABLED_FIELD}: true`
      }
    });
    return {
      isComplete: (data === null || data === void 0 ? void 0 : data.total) > 0
    };
  } catch (e) {
    toasts.addError(e, {
      title: `Failed to check Card Rules completion.`
    });
    return {
      isComplete: false
    };
  }
};
exports.checkRulesComplete = checkRulesComplete;
const fetchRuleManagementFilters = async ({
  http,
  signal,
  query
}) => http.fetch(_constants.DETECTION_ENGINE_RULES_URL_FIND, {
  method: 'GET',
  version: '2023-10-31',
  signal,
  query
});