"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleHistoryRow = exports.GenericHistoryRow = exports.FlyoutHistoryRow = exports.DocumentDetailsHistoryRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _panel_keys = require("../../ai_for_soc/constants/panel_keys");
var _formatted_date = require("../../../common/components/formatted_date");
var _panel_keys2 = require("../../document_details/shared/constants/panel_keys");
var _use_basic_data_from_details_data = require("../../document_details/shared/hooks/use_basic_data_from_details_data");
var _use_event_details = require("../../document_details/shared/hooks/use_event_details");
var _utils = require("../../document_details/shared/utils");
var _right = require("../../rule_details/right");
var _network_details = require("../../network_details");
var _use_rule_details = require("../../rule_details/hooks/use_rule_details");
var _test_ids = require("./test_ids");
var _constants = require("../../entity_details/shared/constants");
var _constants2 = require("../../csp_details/vulnerabilities_flyout/constants");
var _constants3 = require("../../csp_details/findings_flyout/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_WIDTH = 300; // px

/**
 * Row item for a flyout history row
 */
const FlyoutHistoryRow = exports.FlyoutHistoryRow = /*#__PURE__*/(0, _react.memo)(({
  item,
  index
}) => {
  var _item$panel$params, _item$panel$params2, _item$panel, _item$panel$params3, _item$panel2, _item$panel2$params;
  switch (item.panel.id) {
    case _panel_keys2.DocumentDetailsRightPanelKey:
    case _panel_keys.IOCPanelKey:
      return /*#__PURE__*/_react.default.createElement(DocumentDetailsHistoryRow, {
        item: item,
        index: index
      });
    case _right.RulePanelKey:
      return /*#__PURE__*/_react.default.createElement(RuleHistoryRow, {
        item: item,
        index: index
      });
    case _constants.HostPanelKey:
      return /*#__PURE__*/_react.default.createElement(GenericHistoryRow, {
        item: item,
        index: index,
        title: String((_item$panel$params = item.panel.params) === null || _item$panel$params === void 0 ? void 0 : _item$panel$params.hostName),
        icon: 'storage',
        name: 'Host',
        dataTestSubj: _test_ids.HOST_HISTORY_ROW_TEST_ID
      });
    case _constants.UserPanelKey:
      return /*#__PURE__*/_react.default.createElement(GenericHistoryRow, {
        item: item,
        index: index,
        title: String((_item$panel$params2 = item.panel.params) === null || _item$panel$params2 === void 0 ? void 0 : _item$panel$params2.userName),
        icon: 'user',
        name: 'User',
        dataTestSubj: _test_ids.USER_HISTORY_ROW_TEST_ID
      });
    case _network_details.NetworkPanelKey:
      return /*#__PURE__*/_react.default.createElement(GenericHistoryRow, {
        item: item,
        index: index,
        title: String(item === null || item === void 0 ? void 0 : (_item$panel = item.panel) === null || _item$panel === void 0 ? void 0 : (_item$panel$params3 = _item$panel.params) === null || _item$panel$params3 === void 0 ? void 0 : _item$panel$params3.ip),
        icon: 'globe',
        name: 'Network',
        dataTestSubj: _test_ids.NETWORK_HISTORY_ROW_TEST_ID
      });
    case _constants3.MisconfigurationFindingsPanelKey:
    case _constants2.VulnerabilityFindingsPanelKey:
      const TEST_ID = item.panel.id === _constants3.MisconfigurationFindingsPanelKey ? _test_ids.MISCONFIGURATION_HISTORY_ROW_TEST_ID : _test_ids.VULNERABILITY_HISTORY_ROW_TEST_ID;
      return /*#__PURE__*/_react.default.createElement(GenericHistoryRow, {
        item: item,
        index: index,
        title: String(item === null || item === void 0 ? void 0 : (_item$panel2 = item.panel) === null || _item$panel2 === void 0 ? void 0 : (_item$panel2$params = _item$panel2.params) === null || _item$panel2$params === void 0 ? void 0 : _item$panel2$params.resourceId),
        icon: 'document',
        name: 'Resource Id',
        dataTestSubj: TEST_ID
      });
    default:
      return null;
  }
});

/**
 * Row item for a document details
 */
const DocumentDetailsHistoryRow = exports.DocumentDetailsHistoryRow = /*#__PURE__*/(0, _react.memo)(({
  item,
  index
}) => {
  var _item$panel3, _item$panel3$params, _item$panel4, _item$panel4$params;
  const {
    dataFormattedForFieldBrowser,
    getFieldsData,
    loading
  } = (0, _use_event_details.useEventDetails)({
    eventId: String(item === null || item === void 0 ? void 0 : (_item$panel3 = item.panel) === null || _item$panel3 === void 0 ? void 0 : (_item$panel3$params = _item$panel3.params) === null || _item$panel3$params === void 0 ? void 0 : _item$panel3$params.id),
    indexName: String(item === null || item === void 0 ? void 0 : (_item$panel4 = item.panel) === null || _item$panel4 === void 0 ? void 0 : (_item$panel4$params = _item$panel4.params) === null || _item$panel4$params === void 0 ? void 0 : _item$panel4$params.indexName)
  });
  const {
    ruleName,
    isAlert
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const eventKind = (0, _react.useMemo)(() => (0, _utils.getField)(getFieldsData('event.kind')), [getFieldsData]);
  const eventCategory = (0, _react.useMemo)(() => (0, _utils.getField)(getFieldsData('event.category')), [getFieldsData]);
  const title = (0, _react.useMemo)(() => isAlert ? (0, _utils.getAlertTitle)({
    ruleName
  }) : (0, _utils.getEventTitle)({
    eventKind,
    eventCategory,
    getFieldsData
  }), [isAlert, ruleName, eventKind, eventCategory, getFieldsData]);
  return /*#__PURE__*/_react.default.createElement(GenericHistoryRow, {
    item: item,
    index: index,
    title: title,
    icon: isAlert ? 'warning' : 'analyzeEvent',
    name: isAlert ? 'Alert' : 'Event',
    isLoading: loading,
    dataTestSubj: _test_ids.DOCUMENT_DETAILS_HISTORY_ROW_TEST_ID
  });
});
/**
 * Populates the generic row main text
 */
const RowTitle = /*#__PURE__*/(0, _react.memo)(({
  type,
  value
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
          font-weight: ${euiTheme.font.weight.semiBold};
        `
  }, `${type}:`), "\xA0", /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
          max-width: ${MAX_WIDTH}px;
          text-overflow: ellipsis;
          overflow: hidden;
          white-space: nowrap;
        `
  }, value));
});

/**
 * Row item for a rule details flyout
 */
const RuleHistoryRow = exports.RuleHistoryRow = /*#__PURE__*/(0, _react.memo)(({
  item,
  index
}) => {
  var _item$panel5, _item$panel5$params, _rule$name;
  const ruleId = String(item === null || item === void 0 ? void 0 : (_item$panel5 = item.panel) === null || _item$panel5 === void 0 ? void 0 : (_item$panel5$params = _item$panel5.params) === null || _item$panel5$params === void 0 ? void 0 : _item$panel5$params.ruleId);
  const {
    rule,
    loading
  } = (0, _use_rule_details.useRuleDetails)({
    ruleId
  });
  return /*#__PURE__*/_react.default.createElement(GenericHistoryRow, {
    item: item,
    index: index,
    title: (_rule$name = rule === null || rule === void 0 ? void 0 : rule.name) !== null && _rule$name !== void 0 ? _rule$name : '',
    icon: 'indexSettings',
    name: 'Rule',
    isLoading: loading,
    dataTestSubj: _test_ids.RULE_HISTORY_ROW_TEST_ID
  });
});
/**
 * Row item for a generic history row where the title is accessible in flyout params
 */
const GenericHistoryRow = exports.GenericHistoryRow = /*#__PURE__*/(0, _react.memo)(({
  item,
  index,
  title,
  icon,
  name,
  isLoading,
  dataTestSubj
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const onClick = (0, _react.useCallback)(() => {
    openFlyout({
      right: item.panel
    });
  }, [openFlyout, item.panel]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: index,
      "data-test-subj": _test_ids.HISTORY_ROW_LOADING_TEST_ID
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1,
      isLoading: true,
      size: "s"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: index,
    onClick: onClick,
    icon: icon,
    css: (0, _react2.css)`
          align-items: flex-start;
          padding: ${euiTheme.size.s} ${euiTheme.size.m};
        `,
    "data-test-subj": `${index}-${dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : _test_ids.GENERIC_HISTORY_ROW_TEST_ID}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
              flex-direction: row;
            `
  }, /*#__PURE__*/_react.default.createElement(RowTitle, {
    type: name,
    value: title
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
              color: ${euiTheme.colors.textSubdued};
            `
  }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: item.lastOpen
  }))));
});
FlyoutHistoryRow.displayName = 'FlyoutHistoryRow';
DocumentDetailsHistoryRow.displayName = 'DocumentDetailsHistoryRow';
RuleHistoryRow.displayName = 'RuleHistoryRow';
RowTitle.displayName = 'RowTitle';
GenericHistoryRow.displayName = 'GenericHistoryRow';