"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColumns = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _formatted_date = require("../../../../../common/components/formatted_date");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useColumns = () => {
  return (0, _react.useMemo)(() => [{
    field: 'privileged_user',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.sampleDashboard.columns.privilegedUser",
      defaultMessage: "Privileged user"
    }),
    sortable: true
  }, {
    field: 'target_user',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.sampleDashboard.columns.targetUser",
      defaultMessage: "Target user"
    }),
    sortable: true
  }, {
    field: 'right',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.sampleDashboard.columns.grantedRight",
      defaultMessage: "Granted right"
    }),
    sortable: true
  }, {
    field: 'ip',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.sampleDashboard.columns.sourceIp",
      defaultMessage: "Source IP"
    }),
    sortable: true
  }, {
    field: '@timestamp',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.sampleDashboard.columns.timestamp",
      defaultMessage: "Timestamp"
    }),
    dataType: 'date',
    sortable: true,
    render: timestamp => {
      return /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
        value: new Date(timestamp)
      });
    }
  }], []);
};
exports.useColumns = useColumns;