"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeyInsightsTile = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lens_attributes = require("./lens_attributes");
var _visualization_embeddable = require("../../../../../../common/components/visualization_actions/visualization_embeddable");
var _use_esql_global_filter = require("../../../../../../common/hooks/esql/use_esql_global_filter");
var _use_global_time = require("../../../../../../common/containers/use_global_time");
var _use_space_id = require("../../../../../../common/hooks/use_space_id");
var _use_visualization_response = require("../../../../../../common/components/visualization_actions/use_visualization_response");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LENS_VISUALIZATION_HEIGHT = 150;
const LENS_VISUALIZATION_MIN_WIDTH = 220;
const KeyInsightsTile = ({
  title,
  label,
  getEsqlQuery,
  id,
  inspectTitle,
  spaceId: propSpaceId
}) => {
  const filterQuery = (0, _use_esql_global_filter.useEsqlGlobalFilterQuery)();
  const timerange = (0, _use_global_time.useGlobalTime)();
  const hookSpaceId = (0, _use_space_id.useSpaceId)();

  // Use prop spaceId if provided, otherwise use hook spaceId, fallback to 'default'
  const effectiveSpaceId = propSpaceId || hookSpaceId || 'default';
  const lensAttributes = (0, _lens_attributes.createKeyInsightsPanelLensAttributes)({
    title,
    label,
    esqlQuery: getEsqlQuery(effectiveSpaceId),
    dataViewId: 'default-dataview',
    filterQuery
  });
  const visualizationResponse = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId: id
  });

  // Track whether loading has started at least once
  const [hasStartedLoading, setHasStartedLoading] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if ((visualizationResponse === null || visualizationResponse === void 0 ? void 0 : visualizationResponse.loading) === true) {
      setHasStartedLoading(true);
    }
  }, [visualizationResponse === null || visualizationResponse === void 0 ? void 0 : visualizationResponse.loading]);

  // Reset hasStartedLoading when any filter changes to allow fresh error detection
  (0, _react.useEffect)(() => {
    setHasStartedLoading(false);
  }, [timerange.from, timerange.to, filterQuery, effectiveSpaceId]);

  // Only show error state if:
  // 1. Loading has started at least once (hasStartedLoading)
  // 2. Loading is now complete (loading === false)
  // 3. We have no tables (indicating an error)
  if (hasStartedLoading && visualizationResponse && visualizationResponse.loading === false && !visualizationResponse.tables) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      justifyContent: "spaceBetween",
      style: {
        height: '100%'
      } // ensures it uses the full height so 'space-between' works
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        alignSelf: 'flex-end'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "alert",
      color: "warning"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.keyInsightsTile.dataNotAvailable",
      defaultMessage: "Data not available"
    }))))));
  }

  // If we reach here, either still loading or we have a valid response, so show the embeddable
  return /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    applyGlobalQueriesAndFilters: true,
    applyPageAndTabsFilters: true,
    lensAttributes: lensAttributes,
    id: id,
    timerange: timerange,
    width: LENS_VISUALIZATION_MIN_WIDTH,
    height: LENS_VISUALIZATION_HEIGHT,
    disableOnClickFilter: true,
    inspectTitle: inspectTitle
  });
};
exports.KeyInsightsTile = KeyInsightsTile;