"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntegrations = exports.INTEGRATION_OPTION_TEST_ID = void 0;
var _react = require("react");
var _filter = require("../../utils/filter");
var _kibana = require("../../../common/lib/kibana");
var _integrations_filter_button = require("../../components/alert_summary/search_bar/integrations_filter_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTEGRATION_OPTION_TEST_ID = exports.INTEGRATION_OPTION_TEST_ID = 'alert-summary-integration-option-';
/**
 * Combining installed packages and rules to create an interface that the IntegrationFilterButton can take as input (as EuiSelectableOption).
 * If there is no match between a package and the rules, the integration is not returned.
 * If a filter exists (we assume that this filter is negated) we do not mark the integration as checked for the EuiFilterButton.
 */
const useIntegrations = ({
  packages,
  ruleResponse
}) => {
  const {
    data: {
      query: {
        filterManager
      }
    }
  } = (0, _kibana.useKibana)().services;

  // There can be existing rules filtered out, coming when parsing the url
  const currentFilters = filterManager.getFilters();
  const integrations = (0, _react.useMemo)(() => {
    const result = [];
    packages.forEach(p => {
      const matchingRule = ruleResponse.rules.find(r => r.related_integrations.map(ri => ri.package).includes(p.name));
      if (matchingRule) {
        // Retrieves the filter from the key/value pair
        const currentFilter = (0, _filter.filterExistsInFiltersArray)(currentFilters, _integrations_filter_button.FILTER_KEY, matchingRule.rule_id);

        // A EuiSelectableOption is checked only if there is no matching filter for that rule
        const integration = {
          'data-test-subj': `${INTEGRATION_OPTION_TEST_ID}${p.title}`,
          ...(!currentFilter && {
            checked: 'on'
          }),
          key: matchingRule === null || matchingRule === void 0 ? void 0 : matchingRule.rule_id,
          // we save the rule id that we will match again the signal.rule.rule_id field on the alerts
          label: p.title
        };
        result.push(integration);
      }
    });
    return result;
  }, [currentFilters, packages, ruleResponse.rules]);
  return (0, _react.useMemo)(() => ({
    integrations,
    isLoading: ruleResponse.isLoading
  }), [integrations, ruleResponse.isLoading]);
};
exports.useIntegrations = useIntegrations;