"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdditionalToolbarControls = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_get_group_selector = require("@kbn/grouping/src/hooks/use_get_group_selector");
var _reactRedux = require("react-redux");
var _selectors = require("../../../../common/store/grouping/selectors");
var _actions = require("../../../../common/store/grouping/actions");
var _use_selector = require("../../../../common/hooks/use_selector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TABLE_ID = _securitysolutionDataTable.TableId.alertsOnAlertSummaryPage;
const MAX_GROUPING_LEVELS = 3;
const NO_OPTIONS = {
  options: []
};
/**
 * Renders a button that when clicked shows a dropdown to allow selecting a group for the GroupedAlertTable.
 * Handles further communication with the kbn-grouping package via redux.
 */
const AdditionalToolbarControls = exports.AdditionalToolbarControls = /*#__PURE__*/(0, _react.memo)(({
  dataView
}) => {
  var _useDeepEqualSelector;
  const dispatch = (0, _reactRedux.useDispatch)();
  const onGroupChange = (0, _react.useCallback)(selectedGroups => dispatch((0, _actions.updateGroups)({
    activeGroups: selectedGroups,
    tableId: TABLE_ID
  })), [dispatch]);
  const groupId = (0, _react.useMemo)(() => (0, _selectors.groupIdSelector)(), []);
  const {
    options: defaultGroupingOptions
  } = (_useDeepEqualSelector = (0, _use_selector.useDeepEqualSelector)(state => groupId(state, TABLE_ID))) !== null && _useDeepEqualSelector !== void 0 ? _useDeepEqualSelector : NO_OPTIONS;
  const groupSelector = (0, _use_get_group_selector.useGetGroupSelectorStateless)({
    groupingId: TABLE_ID,
    onGroupChange,
    fields: dataView.fields,
    defaultGroupingOptions,
    maxGroupingLevels: MAX_GROUPING_LEVELS
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, groupSelector);
});
AdditionalToolbarControls.displayName = 'AdditionalToolbarControls';