"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkActionsDryRun = void 0;
var _reactQuery = require("@kbn/react-query");
var _logic = require("../../../../rule_management/logic");
var _dry_run_result = require("./utils/dry_run_result");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BULK_ACTIONS_DRY_RUN_QUERY_KEY = 'bulkActionsDryRun';
const useBulkActionsDryRun = () => {
  const {
    data,
    mutateAsync,
    isLoading
  } = (0, _reactQuery.useMutation)([BULK_ACTIONS_DRY_RUN_QUERY_KEY], async bulkAction => {
    let result;
    try {
      result = await (0, _logic.performBulkAction)({
        bulkAction,
        dryRun: true
      });
    } catch (err) {
      var _err$body, _err$body$attributes, _err$body$attributes$;
      // if body doesn't have summary data, action failed altogether and no data available for dry run
      if (((_err$body = err.body) === null || _err$body === void 0 ? void 0 : (_err$body$attributes = _err$body.attributes) === null || _err$body$attributes === void 0 ? void 0 : (_err$body$attributes$ = _err$body$attributes.summary) === null || _err$body$attributes$ === void 0 ? void 0 : _err$body$attributes$.total) === undefined) {
        return;
      }
      result = err.body;
    }
    return (0, _dry_run_result.processDryRunResult)(result);
  });
  return {
    bulkActionsDryRunResult: data,
    isBulkActionsDryRunLoading: isLoading,
    executeBulkActionsDryRun: mutateAsync
  };
};
exports.useBulkActionsDryRun = useBulkActionsDryRun;