"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommonRuleFieldReadOnly = CommonRuleFieldReadOnly;
var _react = _interopRequireDefault(require("react"));
var _related_integrations = require("./fields/related_integrations/related_integrations");
var _required_fields = require("./fields/required_fields/required_fields");
var _severity_mapping = require("./fields/severity_mapping/severity_mapping");
var _risk_score_mapping = require("./fields/risk_score_mapping/risk_score_mapping");
var _threat = require("./fields/threat/threat");
var _name = require("./fields/name/name");
var _tags = require("./fields/tags/tags");
var _description = require("./fields/description/description");
var _utility_types = require("../../../../../../../common/utility_types");
var _building_block = require("./fields/building_block/building_block");
var _investigation_fields = require("./fields/investigation_fields/investigation_fields");
var _false_positives = require("./fields/false_positives/false_positives");
var _max_signals = require("./fields/max_signals/max_signals");
var _note = require("./fields/note/note");
var _rule_schedule = require("./fields/rule_schedule/rule_schedule");
var _references = require("./fields/references/references");
var _risk_score = require("./fields/risk_score/risk_score");
var _rule_name_override = require("./fields/rule_name_override/rule_name_override");
var _setup = require("./fields/setup/setup");
var _severity = require("./fields/severity/severity");
var _timestamp_override = require("./fields/timestamp_override/timestamp_override");
var _timeline_template = require("./fields/timeline_template/timeline_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line complexity
function CommonRuleFieldReadOnly({
  fieldName,
  finalDiffableRule
}) {
  switch (fieldName) {
    case 'building_block':
      return /*#__PURE__*/_react.default.createElement(_building_block.BuildingBlockReadOnly, {
        buildingBlock: finalDiffableRule.building_block
      });
    case 'description':
      return /*#__PURE__*/_react.default.createElement(_description.DescriptionReadOnly, {
        description: finalDiffableRule.description
      });
    case 'investigation_fields':
      return /*#__PURE__*/_react.default.createElement(_investigation_fields.InvestigationFieldsReadOnly, {
        investigationFields: finalDiffableRule.investigation_fields
      });
    case 'false_positives':
      return /*#__PURE__*/_react.default.createElement(_false_positives.FalsePositivesReadOnly, {
        falsePositives: finalDiffableRule.false_positives
      });
    case 'max_signals':
      return /*#__PURE__*/_react.default.createElement(_max_signals.MaxSignalsReadOnly, {
        maxSignals: finalDiffableRule.max_signals
      });
    case 'name':
      return /*#__PURE__*/_react.default.createElement(_name.NameReadOnly, {
        name: finalDiffableRule.name
      });
    case 'note':
      return /*#__PURE__*/_react.default.createElement(_note.NoteReadOnly, {
        note: finalDiffableRule.note
      });
    case 'related_integrations':
      return /*#__PURE__*/_react.default.createElement(_related_integrations.RelatedIntegrationsReadOnly, {
        relatedIntegrations: finalDiffableRule.related_integrations
      });
    case 'required_fields':
      return /*#__PURE__*/_react.default.createElement(_required_fields.RequiredFieldsReadOnly, {
        requiredFields: finalDiffableRule.required_fields
      });
    case 'risk_score_mapping':
      return /*#__PURE__*/_react.default.createElement(_risk_score_mapping.RiskScoreMappingReadOnly, {
        riskScoreMapping: finalDiffableRule.risk_score_mapping
      });
    case 'rule_schedule':
      return /*#__PURE__*/_react.default.createElement(_rule_schedule.RuleScheduleReadOnly, {
        ruleSchedule: finalDiffableRule.rule_schedule
      });
    case 'severity_mapping':
      return /*#__PURE__*/_react.default.createElement(_severity_mapping.SeverityMappingReadOnly, {
        severityMapping: finalDiffableRule.severity_mapping
      });
    case 'tags':
      return /*#__PURE__*/_react.default.createElement(_tags.TagsReadOnly, {
        tags: finalDiffableRule.tags
      });
    case 'threat':
      return /*#__PURE__*/_react.default.createElement(_threat.ThreatReadOnly, {
        threat: finalDiffableRule.threat
      });
    case 'references':
      return /*#__PURE__*/_react.default.createElement(_references.ReferencesReadOnly, {
        references: finalDiffableRule.references
      });
    case 'risk_score':
      return /*#__PURE__*/_react.default.createElement(_risk_score.RiskScoreReadOnly, {
        riskScore: finalDiffableRule.risk_score
      });
    case 'rule_id':
      /* Rule ID is not displayed in the UI */
      return null;
    case 'rule_name_override':
      return /*#__PURE__*/_react.default.createElement(_rule_name_override.RuleNameOverrideReadOnly, {
        ruleNameOverride: finalDiffableRule.rule_name_override
      });
    case 'setup':
      return /*#__PURE__*/_react.default.createElement(_setup.SetupReadOnly, {
        setup: finalDiffableRule.setup
      });
    case 'severity':
      return /*#__PURE__*/_react.default.createElement(_severity.SeverityReadOnly, {
        severity: finalDiffableRule.severity
      });
    case 'timestamp_override':
      return /*#__PURE__*/_react.default.createElement(_timestamp_override.TimestampOverrideReadOnly, {
        timestampOverride: finalDiffableRule.timestamp_override
      });
    case 'timeline_template':
      return /*#__PURE__*/_react.default.createElement(_timeline_template.TimelineTemplateReadOnly, {
        timelineTemplate: finalDiffableRule.timeline_template
      });
    case 'version':
      /* Version is not displayed in the UI */
      return null;
    default:
      return (0, _utility_types.assertUnreachable)(fieldName);
  }
}