"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkRuleSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkRuleSwitch = exports.LinkRuleSwitch = /*#__PURE__*/(0, _react.memo)(({
  rule,
  linkedRules,
  onRuleLinkChange
}) => {
  const isRuleLinked = (0, _react.useMemo)(() => Boolean(linkedRules.find(r => r.id === rule.id)), [linkedRules, rule.id]);
  const onLinkOrUnlinkRule = (0, _react.useCallback)(({
    target: {
      checked
    }
  }) => {
    const newLinkedRules = !checked ? linkedRules === null || linkedRules === void 0 ? void 0 : linkedRules.filter(item => item.id !== rule.id) : [...linkedRules, rule];
    if (typeof onRuleLinkChange === 'function') onRuleLinkChange(newLinkedRules);
  }, [linkedRules, onRuleLinkChange, rule]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    onChange: onLinkOrUnlinkRule,
    checked: isRuleLinked,
    label: i18n.LINK_SWITCH_ARIA_LABEL(rule.name),
    showLabel: false
  }));
});
LinkRuleSwitch.displayName = 'LinkRuleSwitch';