"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepAboutRuleToggleDetails = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _rule_about_section = require("../../../rule_management/components/rule_details/rule_about_section");
var _header_section = require("../../../../common/components/header_section");
var _markdown_editor = require("../../../../common/components/markdown_editor");
var i18n = _interopRequireWildcard(require("./translations"));
var _styles = require("./styles");
var _rule_field_name = require("../../../rule_management/components/rule_details/rule_field_name");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const detailsOption = {
  id: 'details',
  label: i18n.ABOUT_PANEL_DETAILS_TAB,
  'data-test-subj': 'stepAboutDetailsToggle-details'
};
const notesOption = {
  id: 'notes',
  label: i18n.ABOUT_PANEL_NOTES_TAB,
  'data-test-subj': 'stepAboutDetailsToggle-notes'
};
const setupOption = {
  id: 'setup',
  label: i18n.ABOUT_PANEL_SETUP_TAB,
  'data-test-subj': 'stepAboutDetailsToggle-setup'
};
const StepAboutRuleToggleDetailsComponent = ({
  stepData,
  stepDataDetails,
  loading,
  rule
}) => {
  const [selectedToggleOption, setToggleOption] = (0, _react.useState)('details');
  const [aboutPanelHeight, setAboutPanelHeight] = (0, _react.useState)(0);
  const onResize = (0, _react.useCallback)(e => {
    setAboutPanelHeight(e.height);
  }, [setAboutPanelHeight]);
  const toggleOptions = (0, _react.useMemo)(() => {
    const notesExist = !(0, _lodash.isEmpty)(stepDataDetails === null || stepDataDetails === void 0 ? void 0 : stepDataDetails.note) && (stepDataDetails === null || stepDataDetails === void 0 ? void 0 : stepDataDetails.note.trim()) !== '';
    const setupExists = !(0, _lodash.isEmpty)(stepDataDetails === null || stepDataDetails === void 0 ? void 0 : stepDataDetails.setup) && (stepDataDetails === null || stepDataDetails === void 0 ? void 0 : stepDataDetails.setup.trim()) !== '';
    return [...(notesExist || setupExists ? [detailsOption] : []), ...(notesExist ? [notesOption] : []), ...(setupExists ? [setupOption] : [])];
  }, [stepDataDetails === null || stepDataDetails === void 0 ? void 0 : stepDataDetails.note, stepDataDetails === null || stepDataDetails === void 0 ? void 0 : stepDataDetails.setup]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    className: (0, _css.css)`
        position: relative;
      `
  }, loading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  }), /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: i18n.ABOUT_TEXT
  })), stepData != null && stepDataDetails != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    className: _styles.fullHeight
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: "header"
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: i18n.ABOUT_TEXT
  }, toggleOptions.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    options: toggleOptions,
    idSelected: selectedToggleOption,
    onChange: val => {
      setToggleOption(val);
    },
    "data-test-subj": "stepAboutDetailsToggle",
    legend: i18n.ABOUT_CONTROL_LEGEND
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: "details"
  }, selectedToggleOption === 'details' && /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    "data-test-subj": "stepAboutDetailsContent",
    onResize: onResize
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    ref: resizeRef,
    className: _styles.fullHeight
  }, /*#__PURE__*/_react.default.createElement(VerticalOverflowContainer, {
    maxHeight: 120
  }, /*#__PURE__*/_react.default.createElement(VerticalOverflowContent, {
    maxHeight: 120
  }, /*#__PURE__*/_react.default.createElement(RuleDescription, {
    description: stepDataDetails.description
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_rule_about_section.RuleAboutSection, {
    rule: rule,
    hideName: true,
    hideDescription: true
  }))), selectedToggleOption === 'notes' && /*#__PURE__*/_react.default.createElement(VerticalOverflowContainer, {
    maxHeight: aboutPanelHeight
  }, /*#__PURE__*/_react.default.createElement(VerticalOverflowContent, {
    maxHeight: aboutPanelHeight
  }, /*#__PURE__*/_react.default.createElement(RuleInvestigationGuide, {
    note: stepDataDetails.note
  }))), selectedToggleOption === 'setup' && /*#__PURE__*/_react.default.createElement(VerticalOverflowContainer, {
    maxHeight: aboutPanelHeight
  }, /*#__PURE__*/_react.default.createElement(VerticalOverflowContent, {
    maxHeight: aboutPanelHeight
  }, /*#__PURE__*/_react.default.createElement(RuleSetupGuide, {
    setup: stepDataDetails.setup
  }))))));
};
const StepAboutRuleToggleDetails = exports.StepAboutRuleToggleDetails = /*#__PURE__*/(0, _react.memo)(StepAboutRuleToggleDetailsComponent);
function VerticalOverflowContainer({
  maxHeight,
  children
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _css.css)`
        max-height: ${maxHeight}px;
        overflow-y: hidden;
        word-break: break-word;
      `
  }, children);
}
function VerticalOverflowContent({
  maxHeight,
  children
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `eui-yScroll ${(0, _css.css)`
        max-height: ${maxHeight}px;
      `}`
  }, children);
}
const RuleDescription = ({
  description
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
  listItems: [{
    title: /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
      label: i18n.ABOUT_PANEL_DESCRIPTION_LABEL,
      fieldName: "description"
    }),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": "stepAboutRuleDetailsToggleDescriptionText"
    }, description)
  }]
});
const RuleInvestigationGuide = ({
  note
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
  listItems: [{
    title: /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
      fieldName: "note"
    }),
    description: /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownRenderer, null, note)
  }],
  descriptionProps: {
    'data-test-subj': 'stepAboutDetailsNoteContent'
  }
});
const RuleSetupGuide = ({
  setup
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
  listItems: [{
    title: /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
      fieldName: "setup"
    }),
    description: /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownRenderer, null, setup)
  }],
  descriptionProps: {
    'data-test-subj': 'stepAboutDetailsSetupContent'
  }
});