"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntegrationLinkState = exports.getIntegrationLinkState = void 0;
var _react = require("react");
var _navigation = require("@kbn/security-solution-navigation/src/navigation");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIntegrationLinkState = path => {
  const {
    getAppUrl
  } = (0, _navigation.useNavigation)();
  return (0, _react.useMemo)(() => getIntegrationLinkState(path, getAppUrl), [getAppUrl, path]);
};
exports.useIntegrationLinkState = useIntegrationLinkState;
const getIntegrationLinkState = (path, getAppUrl) => {
  const url = getAppUrl({
    appId: _common.APP_UI_ID,
    path
  });
  return {
    onCancelNavigateTo: [_common.APP_UI_ID, {
      path
    }],
    onCancelUrl: url,
    onSaveNavigateTo: [_common.APP_UI_ID, {
      path
    }]
  };
};
exports.getIntegrationLinkState = getIntegrationLinkState;