"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReferenceErrorModalComponent = exports.ReferenceErrorModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _polished = require("polished");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MarkdownContainer = _styledComponents.default.div`
  max-height: 200px;
  overflow-y: auto;

  &::-webkit-scrollbar {
    height: ${({
  theme
}) => theme.eui.euiScrollBar};
    width: ${({
  theme
}) => theme.eui.euiScrollBar};
  }

  &::-webkit-scrollbar-thumb {
    background-clip: content-box;
    background-color: ${({
  theme
}) => (0, _polished.rgba)(theme.eui.euiColorDarkShade, 0.5)};
    border: ${({
  theme
}) => theme.eui.euiScrollBarCorner} solid transparent;
  }

  &::-webkit-scrollbar-corner,
  &::-webkit-scrollbar-track {
    background-color: transparent;
  }
`;
const ReferenceErrorModalComponent = ({
  cancelText,
  confirmText,
  contentText,
  onClose,
  onCancel,
  onConfirm,
  references = [],
  showModal,
  titleText
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  if (!showModal) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    maxWidth: 460,
    "aria-labelledby": modalTitleId,
    title: titleText,
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: cancelText,
    confirmButtonText: confirmText,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    "data-test-subj": "referenceErrorModal"
  }, /*#__PURE__*/_react.default.createElement("p", null, contentText), /*#__PURE__*/_react.default.createElement(MarkdownContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    gutterSize: "none",
    showToolTips: true
  }, references.map((r, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    key: `${index}-${r}`,
    label: r
  })))));
};
exports.ReferenceErrorModalComponent = ReferenceErrorModalComponent;
ReferenceErrorModalComponent.displayName = 'ReferenceErrorModalComponent';
const ReferenceErrorModal = exports.ReferenceErrorModal = /*#__PURE__*/_react.default.memo(ReferenceErrorModalComponent);
ReferenceErrorModal.displayName = 'ReferenceErrorModal';