"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNISOLATE = exports.ISOLATED = exports.GET_UNISOLATION_SUCCESS_MESSAGE = exports.GET_ISOLATION_SUCCESS_MESSAGE = exports.CONFIRM = exports.COMMENT_PLACEHOLDER = exports.COMMENT = exports.CANCEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.cancel', {
  defaultMessage: 'Cancel'
});
const CONFIRM = exports.CONFIRM = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.confirm', {
  defaultMessage: 'Confirm'
});
const COMMENT = exports.COMMENT = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.comment', {
  defaultMessage: 'Comment'
});
const COMMENT_PLACEHOLDER = exports.COMMENT_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.comment.placeholder', {
  defaultMessage: 'You may leave an optional note here.'
});
const GET_ISOLATION_SUCCESS_MESSAGE = hostName => _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.isolation.successfulMessage', {
  defaultMessage: 'Isolation on host {hostName} successfully submitted',
  values: {
    hostName
  }
});
exports.GET_ISOLATION_SUCCESS_MESSAGE = GET_ISOLATION_SUCCESS_MESSAGE;
const GET_UNISOLATION_SUCCESS_MESSAGE = hostName => _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.unisolate.successfulMessage', {
  defaultMessage: 'Release on host {hostName} successfully submitted',
  values: {
    hostName
  }
});
exports.GET_UNISOLATION_SUCCESS_MESSAGE = GET_UNISOLATION_SUCCESS_MESSAGE;
const UNISOLATE = exports.UNISOLATE = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostisolation.unisolate', {
  defaultMessage: 'release'
});
const ISOLATED = exports.ISOLATED = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.isolated', {
  defaultMessage: 'isolated'
});