"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityCellActionsTrigger = exports.SecurityCellActionType = exports.EsqlInTimelineTrigger = exports.EsqlInTimelineAction = exports.DefaultCellActionTypes = void 0;
var _constants = require("@kbn/cell-actions/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let SecurityCellActionsTrigger = exports.SecurityCellActionsTrigger = /*#__PURE__*/function (SecurityCellActionsTrigger) {
  SecurityCellActionsTrigger["DEFAULT"] = "security-default-cellActions";
  SecurityCellActionsTrigger["DETAILS_FLYOUT"] = "security-detailsFlyout-cellActions";
  SecurityCellActionsTrigger["ALERTS_COUNT"] = "security-alertsCount-cellActions";
  return SecurityCellActionsTrigger;
}({});
let EsqlInTimelineTrigger = exports.EsqlInTimelineTrigger = /*#__PURE__*/function (EsqlInTimelineTrigger) {
  EsqlInTimelineTrigger["HISTOGRAM_TRIGGER"] = "security-discoverInTimeline-histogramTrigger";
  return EsqlInTimelineTrigger;
}({});
let EsqlInTimelineAction = exports.EsqlInTimelineAction = /*#__PURE__*/function (EsqlInTimelineAction) {
  EsqlInTimelineAction["VIS_FILTER_ACTION"] = "security-discoverInTimeline-visFilterAction";
  return EsqlInTimelineAction;
}({});
let SecurityCellActionType = exports.SecurityCellActionType = /*#__PURE__*/function (SecurityCellActionType) {
  SecurityCellActionType["FILTER"] = "security-cellAction-type-filter";
  SecurityCellActionType["COPY"] = "security-cellAction-type-copyToClipboard";
  SecurityCellActionType["ADD_TO_TIMELINE"] = "security-cellAction-type-addToTimeline";
  SecurityCellActionType["INVESTIGATE_IN_NEW_TIMELINE"] = "security-cellAction-type-investigateInNewTimeline";
  SecurityCellActionType["SHOW_TOP_N"] = "security-cellAction-type-showTopN";
  SecurityCellActionType["TOGGLE_COLUMN"] = "security-cellAction-type-toggleColumn";
  return SecurityCellActionType;
}({});
const DefaultCellActionTypes = exports.DefaultCellActionTypes = {
  FILTER: _constants.FILTER_CELL_ACTION_TYPE,
  COPY: _constants.COPY_CELL_ACTION_TYPE
};