"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrivmonMonitoringSourceByIdUrl = exports.PRIVMON_USER_PUBLIC_CSV_UPLOAD_URL = exports.PRIVMON_USERS_CSV_SIZE_TOLERANCE_BYTES = exports.PRIVMON_USERS_CSV_MAX_SIZE_BYTES_WITH_TOLERANCE = exports.PRIVMON_USERS_CSV_MAX_SIZE_BYTES = exports.PRIVMON_PUBLIC_URL = exports.PRIVMON_PUBLIC_INIT = exports.PRIVMON_ENGINE_PUBLIC_URL = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PRIVMON_PUBLIC_URL = exports.PRIVMON_PUBLIC_URL = `/api/entity_analytics/monitoring`;
const PRIVMON_ENGINE_PUBLIC_URL = exports.PRIVMON_ENGINE_PUBLIC_URL = `${PRIVMON_PUBLIC_URL}/engine`;
const PRIVMON_USER_PUBLIC_CSV_UPLOAD_URL = exports.PRIVMON_USER_PUBLIC_CSV_UPLOAD_URL = `${PRIVMON_PUBLIC_URL}/users/_csv`;
const PRIVMON_PUBLIC_INIT = exports.PRIVMON_PUBLIC_INIT = `${PRIVMON_PUBLIC_URL}/engine/init`;
const getPrivmonMonitoringSourceByIdUrl = id => `${PRIVMON_PUBLIC_URL}/entity_source/${id}`;
exports.getPrivmonMonitoringSourceByIdUrl = getPrivmonMonitoringSourceByIdUrl;
const PRIVMON_USERS_CSV_MAX_SIZE_BYTES = exports.PRIVMON_USERS_CSV_MAX_SIZE_BYTES = 1024 * 1024; // 1MB
const PRIVMON_USERS_CSV_SIZE_TOLERANCE_BYTES = exports.PRIVMON_USERS_CSV_SIZE_TOLERANCE_BYTES = 1024 * 50; // ~= 50kb
const PRIVMON_USERS_CSV_MAX_SIZE_BYTES_WITH_TOLERANCE = exports.PRIVMON_USERS_CSV_MAX_SIZE_BYTES_WITH_TOLERANCE = PRIVMON_USERS_CSV_MAX_SIZE_BYTES + PRIVMON_USERS_CSV_SIZE_TOLERANCE_BYTES;