"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  PlaygroundPageMode: true,
  PlaygroundFormFields: true,
  SavedPlaygroundFormFields: true,
  PlaygroundViewMode: true
};
exports.SavedPlaygroundFormFields = exports.PlaygroundViewMode = exports.PlaygroundPageMode = exports.PlaygroundFormFields = void 0;
var _types = require("../common/types");
Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _types[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _types[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let PlaygroundPageMode = exports.PlaygroundPageMode = /*#__PURE__*/function (PlaygroundPageMode) {
  PlaygroundPageMode["chat"] = "chat";
  PlaygroundPageMode["search"] = "search";
  return PlaygroundPageMode;
}({}); // eslint-disable-next-line @typescript-eslint/no-empty-interface
// eslint-disable-next-line @typescript-eslint/no-empty-interface
let PlaygroundFormFields = exports.PlaygroundFormFields = /*#__PURE__*/function (PlaygroundFormFields) {
  PlaygroundFormFields["question"] = "question";
  PlaygroundFormFields["citations"] = "citations";
  PlaygroundFormFields["prompt"] = "prompt";
  PlaygroundFormFields["indices"] = "indices";
  PlaygroundFormFields["elasticsearchQuery"] = "elasticsearch_query";
  PlaygroundFormFields["userElasticsearchQuery"] = "user_elasticsearch_query";
  PlaygroundFormFields["summarizationModel"] = "summarization_model";
  PlaygroundFormFields["sourceFields"] = "source_fields";
  PlaygroundFormFields["docSize"] = "doc_size";
  PlaygroundFormFields["queryFields"] = "query_fields";
  PlaygroundFormFields["searchQuery"] = "search_query";
  return PlaygroundFormFields;
}({});
var SavedPlaygroundFields = /*#__PURE__*/function (SavedPlaygroundFields) {
  SavedPlaygroundFields["name"] = "name";
  return SavedPlaygroundFields;
}(SavedPlaygroundFields || {});
const SavedPlaygroundFormFields = exports.SavedPlaygroundFormFields = {
  ...PlaygroundFormFields,
  ...SavedPlaygroundFields
};
exports.PlaygroundPageMode = PlaygroundPageMode = /*#__PURE__*/function (PlaygroundPageMode) {
  PlaygroundPageMode["Chat"] = "chat";
  PlaygroundPageMode["Search"] = "search";
  return PlaygroundPageMode;
}(PlaygroundPageMode || {});
let PlaygroundViewMode = exports.PlaygroundViewMode = /*#__PURE__*/function (PlaygroundViewMode) {
  PlaygroundViewMode["preview"] = "preview";
  PlaygroundViewMode["query"] = "query";
  return PlaygroundViewMode;
}({});