"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummarizationModel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../analytics/constants");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _use_management_link = require("../../hooks/use_management_link");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getOptionValue = model => model.connectorId + model.name;
const SummarizationModel = ({
  selectedModel,
  models,
  onSelect
}) => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const managementLink = (0, _use_management_link.useManagementLink)((selectedModel === null || selectedModel === void 0 ? void 0 : selectedModel.connectorId) || '');
  const onChange = modelValue => {
    const newSelectedModel = models.find(model => getOptionValue(model) === modelValue);
    if (newSelectedModel) {
      onSelect(newSelectedModel);
    }
  };
  const modelsOption = (0, _react.useMemo)(() => models.map(model => ({
    value: getOptionValue(model),
    disabled: model.disabled,
    inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: model.icon
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      gutterSize: "s",
      css: {
        overflow: 'hidden'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, model.name), model.showConnectorName && model.connectorName && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      css: {
        overflow: 'hidden',
        textOverflow: 'ellipsis',
        textWrap: 'nowrap'
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      title: model.connectorName
    }, model.connectorName)))),
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: model.icon
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, model.name), model.showConnectorName && model.connectorName && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, model.connectorName)))
  })), [models]);
  (0, _react.useEffect)(() => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(`${_constants.AnalyticsEvents.modelSelected}_${(selectedModel === null || selectedModel === void 0 ? void 0 : selectedModel.value) || (selectedModel === null || selectedModel === void 0 ? void 0 : selectedModel.connectorType) || 'unknown'}`);
  }, [usageTracker, selectedModel]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    css: {
      '.euiFormLabel': {
        display: 'flex',
        alignItems: 'center'
      }
    },
    "data-test-subj": "aiConnectorTitle",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.sidebar.summarizationModel.label",
      defaultMessage: "AI Connector"
    }), ' '),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "summarizationModelSelect",
    options: modelsOption,
    valueOfSelected: selectedModel && getOptionValue(selectedModel),
    onChange: onChange,
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    target: "_blank",
    href: managementLink,
    "data-test-subj": "manageConnectorsLink",
    iconType: "wrench",
    size: "s",
    "aria-label": _i18n.i18n.translate('xpack.searchPlayground.sidebar.summarizationModel.manageConnectorLink', {
      defaultMessage: 'Manage connector'
    })
  }))));
};
exports.SummarizationModel = SummarizationModel;