"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabSummary = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_status = require("../../job_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TabSummary extends _react.Component {
  renderStats() {
    const {
      stats
    } = this.props;
    if (!stats) {
      return null;
    }
    const {
      documentsProcessed,
      pagesProcessed,
      rollupsIndexed,
      triggerCount,
      status
    } = stats;
    return /*#__PURE__*/_react.default.createElement("section", {
      "aria-labelledby": "rollupJobDetailStatsTitle",
      "data-test-subj": "rollupJobDetailSummaryStatsSection"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", {
      id: "rollupJobDetailStatsTitle",
      "data-test-subj": "rollupJobDetailStatsTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.sectionStatsTitle",
      defaultMessage: "Stats"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_job_status.JobStatus, {
      status: status
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemDocumentsProcessedLabel",
      "data-test-subj": "rollupJobDetailStatsDocumentsProcessedTitle",
      defaultMessage: "Documents processed"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "rollupJobDetailStatsDocumentsProcessedDescription"
    }, documentsProcessed), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemRollupsIndexedLabel",
      "data-test-subj": "rollupJobDetailStatsRollupsIndexedTitle",
      defaultMessage: "Rollups indexed"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "rollupJobDetailStatsRollupsIndexedDescription"
    }, rollupsIndexed))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemPagesProcessedLabel",
      "data-test-subj": "rollupJobDetailStatsPagesProcessedTitle",
      defaultMessage: "Pages processed"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "rollupJobDetailStatsPagesProcessedDescription"
    }, pagesProcessed), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemTriggerCountLabel",
      "data-test-subj": "rollupJobDetailStatsTriggerCountTitle",
      defaultMessage: "Trigger count"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "rollupJobDetailStatsTriggerCountDescription"
    }, triggerCount)))));
  }
  render() {
    const {
      job
    } = this.props;
    const {
      indexPattern,
      rollupIndex,
      rollupCron,
      rollupDelay,
      dateHistogramInterval,
      dateHistogramTimeZone,
      dateHistogramField
    } = job;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("section", {
      "aria-labelledby": "rollupJobDetailLogisticsTitle",
      "data-test-subj": "rollupJobDetailSummaryLogisticsSection"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", {
      id: "rollupJobDetailLogisticsTitle",
      "data-test-subj": "rollupJobDetailLogisticsTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.sectionLogisticsLabel",
      defaultMessage: "Logistics"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemIndexPatternLabel",
      "data-test-subj": "rollupJobDetailLogisticsIndexPatternTitle",
      defaultMessage: "Index pattern"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textBreakWord",
      "data-test-subj": "rollupJobDetailLogisticsIndexPatternDescription"
    }, indexPattern), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemCronLabel",
      "data-test-subj": "rollupJobDetailLogisticsCronTitle",
      defaultMessage: "Cron"
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.jobDetails.tabSummary.itemCronTip",
        defaultMessage: "The frequency with which data is rolled up"
      })
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "rollupJobDetailLogisticsCronDescription"
    }, rollupCron))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemRollupIndexLabel",
      "data-test-subj": "rollupJobDetailLogisticsRollupIndexTitle",
      defaultMessage: "Rollup index"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textBreakWord",
      "data-test-subj": "rollupJobDetailLogisticsRollupIndexDescription"
    }, rollupIndex), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemDelayLabel",
      "data-test-subj": "rollupJobDetailLogisticsDelayTitle",
      defaultMessage: "Delay"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "rollupJobDetailLogisticsDelayDescription"
    }, rollupDelay || /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemDelay.none",
      defaultMessage: "None"
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    })), /*#__PURE__*/_react.default.createElement("section", {
      "aria-labelledby": "rollupJobDetailDateHistogramTitle",
      "data-test-subj": "rollupJobDetailSummaryDateHistogramSection"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", {
      id: "rollupJobDetailDateHistogramTitle",
      "data-test-subj": "rollupJobDetailDateHistogramTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.sectionDateHistogramLabel",
      defaultMessage: "Date histogram"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemTimeFieldLabel",
      "data-test-subj": "rollupJobDetailDateHistogramTimeFieldTitle",
      defaultMessage: "Time field"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textBreakWord",
      "data-test-subj": "rollupJobDetailDateHistogramTimeFieldDescription"
    }, dateHistogramField), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemIntervalLabel",
      "data-test-subj": "rollupJobDetailDateHistogramIntervalTitle",
      defaultMessage: "Interval"
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.jobDetails.tabSummary.itemIntervalTip",
        defaultMessage: "The time bucket interval into which data is rolled up"
      })
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "rollupJobDetailDateHistogramIntervalDescription"
    }, dateHistogramInterval))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemTimezoneLabel",
      "data-test-subj": "rollupJobDetailDateHistogramTimezoneTitle",
      defaultMessage: "Timezone"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "rollupJobDetailDateHistogramTimezoneDescription"
    }, dateHistogramTimeZone))))), this.renderStats());
  }
}
exports.TabSummary = TabSummary;
(0, _defineProperty2.default)(TabSummary, "propTypes", {
  job: _propTypes.default.object.isRequired,
  stats: _propTypes.default.object
});