"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecationCallout = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _documentation_links = require("../../../services/documentation_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
A component for displaying a deprecation warning.
 */
const DeprecationCallout = ({
  linksTestSubjPrefix
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Deprecated in 8.11.0",
    color: "warning",
    iconType: "warning",
    "data-test-subj": "rollupDeprecationCallout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.rollupJobs.deprecationCalloutMessage",
    defaultMessage: "Rollups are deprecated and will be removed in a future version. Check our {migrationGuideLink} and use {downsamplingLink} instead.",
    values: {
      migrationGuideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _documentation_links.documentationLinks.elasticsearch.rollupMigratingToDownsampling,
        target: "_blank",
        "data-test-subj": `${linksTestSubjPrefix}-rollupDeprecationCalloutMigrationGuideLink`
      }, _i18n.i18n.translate('xpack.rollupJobs.deprecationCallout.migrationGuideLink', {
        defaultMessage: 'migration guide'
      })),
      downsamplingLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _documentation_links.documentationLinks.fleet.datastreamsDownsampling,
        target: "_blank",
        "data-test-subj": `${linksTestSubjPrefix}-rollupDeprecationCalloutDownsamplingDocLink`
      }, _i18n.i18n.translate('xpack.rollupJobs.deprecationCallout.downsamplingLink', {
        defaultMessage: 'downsampling'
      }))
    }
  }));
};
exports.DeprecationCallout = DeprecationCallout;