"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterEdit = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _shared_imports = require("../../../shared_imports");
var _services = require("../../services");
var _breadcrumb = require("../../services/breadcrumb");
var _components = require("../components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FORM_MAX_WIDTH = 850;
const RemoteClusterEdit = ({
  isLoading,
  cluster,
  startEditingCluster,
  stopEditingCluster,
  editCluster,
  isEditingCluster,
  getEditClusterError,
  clearEditClusterErrors,
  openDetailPanel
}) => {
  const match = (0, _reactRouterDom.useRouteMatch)();
  const {
    name: clusterName
  } = match.params;
  const {
    history,
    route: {
      location: {
        search
      }
    }
  } = (0, _services.getRouter)();
  (0, _react.useEffect)(() => {
    (0, _breadcrumb.setBreadcrumbs)('edit', `?cluster=${clusterName}`);
    startEditingCluster(clusterName);
    return () => {
      clearEditClusterErrors();
      stopEditingCluster();
    };
  }, [clusterName, startEditingCluster, clearEditClusterErrors, stopEditingCluster]);
  const cancel = () => {
    const {
      redirect: redirectUrl
    } = (0, _shared_imports.extractQueryParams)(search);
    if (redirectUrl && typeof redirectUrl === 'string') {
      const decodedRedirect = decodeURIComponent(redirectUrl);
      (0, _services.redirect)(decodedRedirect);
    } else {
      history.push('/list');
      openDetailPanel(clusterName);
    }
  };
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.edit.loadingLabel",
      defaultMessage: "Loading remote cluster\u2026"
    }));
  }
  if (!cluster) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      iconType: "warning",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.edit.loadingErrorTitle",
        defaultMessage: "Error loading remote cluster"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.edit.loadingErrorMessage",
        defaultMessage: "The remote cluster ''{name}'' does not exist.",
        values: {
          name: clusterName
        }
      })),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, '/list'), {
        color: "danger",
        iconType: "arrowLeft"
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.edit.viewRemoteClustersButtonLabel",
        defaultMessage: "View remote clusters"
      }))
    });
  }
  const {
    hasDeprecatedProxySetting
  } = cluster;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: true,
    "data-test-subj": "remote-clusters-edit"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: FORM_MAX_WIDTH
  }, /*#__PURE__*/_react.default.createElement(_components.RemoteClusterPageTitle, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.editTitle",
      defaultMessage: "Edit remote cluster"
    })
  }), hasDeprecatedProxySetting ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.edit.deprecatedSettingsTitle",
      defaultMessage: "Proceed with caution"
    }),
    color: "warning",
    iconType: "question"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.edit.deprecatedSettingsMessage",
    defaultMessage: "This remote cluster has deprecated settings that we tried to resolve. Verify all changes before saving."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_components.RemoteClusterForm, {
    cluster: cluster,
    isSaving: isEditingCluster,
    saveError: getEditClusterError,
    confirmFormAction: editCluster,
    onBack: cancel,
    confirmFormText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.edit.save",
      defaultMessage: "Save"
    }),
    backFormText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.cancelButtonLabel",
      defaultMessage: "Cancel"
    })
  })));
};
exports.RemoteClusterEdit = RemoteClusterEdit;