"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterReview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../common/constants");
var _documentation = require("../../../../services/documentation");
var _app_context = require("../../../../app_context");
var _components = require("../components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RemoteClusterReview = ({
  onBack,
  onSubmit,
  isSaving,
  saveError,
  cluster,
  securityModel
}) => {
  const context = (0, _react.useContext)(_app_context.AppContext);
  const {
    isCloudEnabled,
    cloudDeploymentUrl
  } = context;
  const onPremSteps = [{
    title: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.onPrem.step1.title', {
      defaultMessage: 'Confirm both clusters are compatible'
    }),
    status: 'incomplete',
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.onPrem.step1.paragraph",
      defaultMessage: "Ensure that both clusters meet the {requirmentsLink} needed to enable the connection.",
      values: {
        requirmentsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: securityModel === _constants.SECURITY_MODEL.API ? _documentation.onPremPrerequisitesApiKey : _documentation.onPremPrerequisitesCert,
          external: true,
          target: "_blank",
          "data-test-subj": "remoteClusterReviewOnPremStep1"
        }, _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.onPrem.step1.requirements', {
          defaultMessage: 'requirements'
        }))
      }
    }))
  }, {
    title: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.onPrem.step2.title', {
      defaultMessage: 'Confirm trust is established'
    }),
    status: 'incomplete',
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.onPrem.step2.paragraph",
      defaultMessage: "Follow the {addRemoteClusterGuideLink} to establish trust between local and remote clusters.",
      values: {
        addRemoteClusterGuideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: securityModel === _constants.SECURITY_MODEL.API ? _documentation.onPremSecurityApiKey : _documentation.onPremSecurityCert,
          external: true,
          target: "_blank",
          "data-test-subj": "remoteClusterReviewOnPremStep2"
        }, _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.onPrem.step1.addClustersGuide', {
          defaultMessage: 'Add remote clusters guide'
        }))
      }
    }))
  }];
  const cloudSteps = [{
    title: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.cloud.api.step1.title', {
      defaultMessage: 'Create a cross-cluster API key on the remote deployment'
    }),
    status: 'incomplete',
    'data-test-subj': 'cloudApiKeySteps',
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.cloud.api.step1.paragraph1",
      defaultMessage: "On the remote cluster or deployment, use the {apiLink} or {kibanaLink} to create a cross-cluster API key. Configure it with access to the indices you want to use for cross-cluster search or cross-cluster replication.",
      values: {
        apiLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.cloudCreateApiKey,
          external: true,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.cloud.api.step1.paragraph1.api', {
          defaultMessage: 'Elasticsearch API'
        })),
        kibanaLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.apiKeys,
          external: true,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.cloud.api.step1.paragraph1.kibana', {
          defaultMessage: 'Kibana'
        }))
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.cloud.api.step1.paragraph2",
      defaultMessage: "Copy the encoded key (the \u201Cencoded\u201D value from the response) to a safe location. You will need it in the next step."
    })))
  }, {
    title: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.cloud.api.step2.title', {
      defaultMessage: 'Configure your local deployment'
    }),
    status: 'incomplete',
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.cloud.api.step2.intro",
      defaultMessage: "Add the key that you created to your local deployment's keystore:"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("ol", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.cloud.api.step2.list1",
      defaultMessage: "Go to the {managementLink} page for your deployment.",
      values: {
        managementLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: cloudDeploymentUrl,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.cloud.api.step2.list1.management', {
          defaultMessage: 'management'
        }))
      }
    })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.cloud.api.step2.list2",
      defaultMessage: "From the navigation menu, click Security."
    })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.cloud.api.step2.list3",
      defaultMessage: "In the Remote connections section, add your API key."
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.cloud.api.step2.end",
      defaultMessage: "Check {documentationLink} for more detailed instructions.",
      values: {
        documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.cloudSetupTrustUrl,
          external: true,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.cloud.api.step2.end.documentation', {
          defaultMessage: 'documentation'
        }))
      }
    })))
  }];
  const getOnPremInfo = () => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.onPrem.disclaimerInfo",
      defaultMessage: "Check that the following requirements are completed to ensure that both clusters can communicate:"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
      "data-test-subj": "remoteClusterReviewOnPremSteps",
      titleSize: "s",
      steps: onPremSteps
    }));
  };
  const getCloudInfo = () => {
    return securityModel === _constants.SECURITY_MODEL.API ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.cloud.disclaimerInfo",
      defaultMessage: "Make sure you complete the steps below before proceeding with saving this configuration."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
      titleSize: "s",
      steps: cloudSteps
    })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.cloud.cert.title",
      defaultMessage: "Confirm trust is established."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": "cloudCertDocumentation"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.cloud.cert.paragraph",
      defaultMessage: "Before you proceed, ensure that trust is correctly configured between both clusters. If all requirements are not met, the remote cluster won't connect. {detailsLink}",
      values: {
        detailsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.cloudSetupTrustUrl,
          external: true,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.cloud.cert.paragraph.documentationLink', {
          defaultMessage: 'Read details.'
        }))
      },
      "data-test-subj": "cloudCertDocumentation"
    })));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, saveError && /*#__PURE__*/_react.default.createElement(_components.SaveError, {
    saveError: saveError
  }), isCloudEnabled ? getCloudInfo() : getOnPremInfo(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_components.ActionButtons, {
    showRequest: true,
    isSaving: isSaving,
    handleNext: onSubmit,
    onBack: onBack,
    confirmFormText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.addClusterButtonLabel",
      defaultMessage: "Add remote cluster"
    }),
    backFormText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.backButtonLabel",
      defaultMessage: "Back"
    }),
    cluster: cluster,
    nextButtonTestSubj: 'remoteClusterReviewtNextButton',
    backButtonTestSubj: 'remoteClusterReviewtBackButton'
  }));
};
exports.RemoteClusterReview = RemoteClusterReview;