"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMockedAgent = exports.createInternalAgentRegistryMock = exports.createAgentsServiceStartMock = exports.createAgentRegistryMock = exports.createAgentProviderMock = void 0;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMockedAgent = (parts = {}) => {
  return {
    type: _onechatCommon.AgentType.conversational,
    id: 'test_agent',
    providerId: 'provider_id',
    description: 'My test agent',
    handler: jest.fn().mockReturnValue({
      result: 'result'
    }),
    ...parts
  };
};
exports.createMockedAgent = createMockedAgent;
const createAgentProviderMock = (id = 'test_provider') => {
  return {
    id,
    has: jest.fn(),
    get: jest.fn(),
    list: jest.fn()
  };
};
exports.createAgentProviderMock = createAgentProviderMock;
const createAgentRegistryMock = () => {
  return {
    has: jest.fn(),
    get: jest.fn(),
    list: jest.fn()
  };
};
exports.createAgentRegistryMock = createAgentRegistryMock;
const createInternalAgentRegistryMock = () => {
  return {
    has: jest.fn(),
    get: jest.fn(),
    list: jest.fn(),
    asPublicRegistry: jest.fn().mockImplementation(() => createAgentRegistryMock())
  };
};
exports.createInternalAgentRegistryMock = createInternalAgentRegistryMock;
const createAgentsServiceStartMock = () => {
  return {
    registry: createInternalAgentRegistryMock(),
    execute: jest.fn()
  };
};
exports.createAgentsServiceStartMock = createAgentsServiceStartMock;