"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerToolsRoutes = registerToolsRoutes;
var _wrap_handler = require("./wrap_handler");
var _tool_conversion = require("../services/tools/utils/tool_conversion");
var _features = require("../../common/features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerToolsRoutes({
  router,
  getInternalServices,
  logger
}) {
  const wrapHandler = (0, _wrap_handler.getHandlerWrapper)({
    logger
  });
  router.post({
    path: '/internal/onechat/tools',
    security: {
      authz: {
        requiredPrivileges: [_features.apiPrivileges.readOnechat]
      }
    },
    validate: false
  }, wrapHandler(async (ctx, request, response) => {
    const {
      tools: toolService
    } = getInternalServices();
    const registry = toolService.registry.asScopedPublicRegistry({
      request
    });
    const tools = await registry.list({});
    return response.ok({
      body: {
        tools: tools.map(_tool_conversion.toolToDescriptor)
      }
    });
  }));
}