"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerConversationRoutes = registerConversationRoutes;
var _configSchema = require("@kbn/config-schema");
var _wrap_handler = require("./wrap_handler");
var _features = require("../../common/features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerConversationRoutes({
  router,
  getInternalServices,
  logger
}) {
  const wrapHandler = (0, _wrap_handler.getHandlerWrapper)({
    logger
  });
  router.post({
    path: '/internal/onechat/conversations',
    security: {
      authz: {
        requiredPrivileges: [_features.apiPrivileges.readOnechat]
      }
    },
    validate: {
      body: _configSchema.schema.object({
        agentId: _configSchema.schema.maybe(_configSchema.schema.string({}))
      })
    }
  }, wrapHandler(async (ctx, request, response) => {
    const {
      conversations: conversationsService
    } = getInternalServices();
    const {
      agentId
    } = request.body;
    const client = await conversationsService.getScopedClient({
      request
    });
    const conversations = await client.list({
      agentId
    });
    return response.ok({
      body: {
        conversations
      }
    });
  }));
}