"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractToolCalls = exports.extractTextContent = void 0;
var _messages = require("@langchain/core/messages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Extract the text content from a langchain message or chunk.
 */
const extractTextContent = message => {
  if (typeof message.content === 'string') {
    return message.content;
  } else {
    let content = '';
    for (const item of message.content) {
      if (item.type === 'text') {
        content += item.text;
      }
    }
    return content;
  }
};
exports.extractTextContent = extractTextContent;
/**
 * Extracts the tool calls from a message.
 */
const extractToolCalls = message => {
  if ((0, _messages.isAIMessage)(message)) {
    var _message$tool_calls$m, _message$tool_calls;
    return (_message$tool_calls$m = (_message$tool_calls = message.tool_calls) === null || _message$tool_calls === void 0 ? void 0 : _message$tool_calls.map(toolCall => {
      if (!toolCall.id) {
        throw new Error('Tool call must have an id');
      }
      return {
        toolCallId: toolCall.id,
        toolName: toolCall.name,
        args: toolCall.args
      };
    })) !== null && _message$tool_calls$m !== void 0 ? _message$tool_calls$m : [];
  }
  return [];
};
exports.extractToolCalls = extractToolCalls;