"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.matchName = exports.matchGraphNode = exports.matchGraphName = exports.matchEvent = exports.isStreamEvent = exports.hasTag = exports.createTextChunkEvent = exports.createReasoningEvent = exports.createMessageEvent = void 0;
var _agents = require("@kbn/onechat-common/agents");
var _messages = require("./messages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isStreamEvent = input => {
  return 'event' in input && 'name' in input;
};
exports.isStreamEvent = isStreamEvent;
const matchGraphName = (event, graphName) => {
  return event.metadata.graphName === graphName;
};
exports.matchGraphName = matchGraphName;
const matchGraphNode = (event, nodeName) => {
  return event.metadata.langgraph_node === nodeName;
};
exports.matchGraphNode = matchGraphNode;
const matchEvent = (event, eventName) => {
  return event.event === eventName;
};
exports.matchEvent = matchEvent;
const matchName = (event, name) => {
  return event.name === name;
};
exports.matchName = matchName;
const hasTag = (event, tag) => {
  var _event$tags;
  return ((_event$tags = event.tags) !== null && _event$tags !== void 0 ? _event$tags : []).includes(tag);
};
exports.hasTag = hasTag;
const createTextChunkEvent = (chunk, {
  defaultMessageId = 'unknown'
} = {}) => {
  var _chunk$id;
  return {
    type: _agents.ChatAgentEventType.messageChunk,
    data: {
      messageId: (_chunk$id = chunk.id) !== null && _chunk$id !== void 0 ? _chunk$id : defaultMessageId,
      textChunk: (0, _messages.extractTextContent)(chunk)
    }
  };
};
exports.createTextChunkEvent = createTextChunkEvent;
const createMessageEvent = (content, {
  messageId = 'unknown'
} = {}) => {
  return {
    type: _agents.ChatAgentEventType.messageComplete,
    data: {
      messageId,
      messageContent: content
    }
  };
};
exports.createMessageEvent = createMessageEvent;
const createReasoningEvent = reasoning => {
  return {
    type: _agents.ChatAgentEventType.reasoning,
    data: {
      reasoning
    }
  };
};
exports.createReasoningEvent = createReasoningEvent;