"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupingToolbarControls = void 0;
var _react = _interopRequireWildcard(require("react"));
var _alertsGrouping = require("@kbn/alerts-grouping");
var _use_alerts_data_view = require("@kbn/alerts-ui-shared/src/common/hooks/use_alerts_data_view");
var _use_get_group_selector = require("@kbn/grouping/src/hooks/use_get_group_selector");
var _kibana_react = require("../../../utils/kibana_react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GroupingToolbarControls = exports.GroupingToolbarControls = /*#__PURE__*/_react.default.memo(({
  groupingId,
  ruleTypeIds,
  maxGroupingLevels = 3
}) => {
  var _dataView$fields, _grouping$options$fil, _grouping$options;
  const {
    dataViews,
    http,
    notifications
  } = (0, _kibana_react.useKibana)().services;
  const {
    grouping,
    updateGrouping
  } = (0, _alertsGrouping.useAlertsGroupingState)(groupingId);
  const onGroupChange = (0, _react.useCallback)(selectedGroups => {
    var _grouping$activeGroup, _grouping$activeGroup2;
    updateGrouping({
      activeGroups: (_grouping$activeGroup = (_grouping$activeGroup2 = grouping.activeGroups) === null || _grouping$activeGroup2 === void 0 ? void 0 : _grouping$activeGroup2.filter(g => g !== 'none').concat(selectedGroups)) !== null && _grouping$activeGroup !== void 0 ? _grouping$activeGroup : []
    });
  }, [grouping, updateGrouping]);
  const {
    dataView
  } = (0, _use_alerts_data_view.useAlertsDataView)({
    ruleTypeIds,
    dataViewsService: dataViews,
    http,
    toasts: notifications.toasts
  });
  return (0, _use_get_group_selector.useGetGroupSelectorStateless)({
    groupingId,
    onGroupChange,
    fields: (_dataView$fields = dataView === null || dataView === void 0 ? void 0 : dataView.fields) !== null && _dataView$fields !== void 0 ? _dataView$fields : [],
    defaultGroupingOptions: (_grouping$options$fil = (_grouping$options = grouping.options) === null || _grouping$options === void 0 ? void 0 : _grouping$options.filter(option => !grouping.activeGroups.includes(option.key))) !== null && _grouping$options$fil !== void 0 ? _grouping$options$fil : [],
    maxGroupingLevels
  });
});