"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DownloadTemplateCallout = DownloadTemplateCallout;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _aws_firehose = require("../../../../common/aws_firehose");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DownloadTemplateCallout() {
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.firehosePanel.downloadTemplateDescription",
    defaultMessage: "{downloadLink} to review the default settings. If needed, you can modify the default settings and use the template with your existing IaC setup.",
    values: {
      downloadLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "observabilityOnboardingFirehosePanelDownloadCloudFormationTemplateLink",
        href: _aws_firehose.FIREHOSE_CLOUDFORMATION_TEMPLATE_URL,
        download: true
      }, _i18n.i18n.translate('xpack.observability_onboarding.firehosePanel.downloadCloudFormationTemplateButtonLabel', {
        defaultMessage: 'Download the CloudFormation template'
      }))
    }
  });
}