"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertInferenceEventsToStreamingEvents = convertInferenceEventsToStreamingEvents;
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _inferenceCommon = require("@kbn/inference-common");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertInferenceEventsToStreamingEvents() {
  return events$ => {
    return events$.pipe((0, _rxjs.filter)(event => event.type !== _inferenceCommon.ChatCompletionEventType.ChatCompletionTokenCount), (0, _rxjs.map)(event => {
      switch (event.type) {
        case _inferenceCommon.ChatCompletionEventType.ChatCompletionChunk:
          // Convert to ChatCompletionChunkEvent
          return {
            type: _common.StreamingChatResponseEventType.ChatCompletionChunk,
            id: (0, _uuid.v4)(),
            message: {
              content: event.content,
              function_call: event.tool_calls.length > 0 ? {
                name: event.tool_calls[0].function.name,
                arguments: event.tool_calls[0].function.arguments
              } : undefined
            },
            ...(event.deanonymized_input && {
              deanonymized_input: event.deanonymized_input
            }),
            ...(event.deanonymized_output && {
              deanonymized_output: event.deanonymized_output
            })
          };
        case _inferenceCommon.ChatCompletionEventType.ChatCompletionMessage:
          // Convert to ChatCompletionMessageEvent
          return {
            type: _common.StreamingChatResponseEventType.ChatCompletionMessage,
            id: (0, _uuid.v4)(),
            message: {
              content: event.content,
              function_call: event.toolCalls.length > 0 ? {
                name: event.toolCalls[0].function.name,
                arguments: event.toolCalls[0].function.arguments
              } : undefined
            },
            ...(event.deanonymized_input && {
              deanonymized_input: event.deanonymized_input
            }),
            ...(event.deanonymized_output && {
              deanonymized_output: event.deanonymized_output
            })
          };
        default:
          throw new Error(`Unknown event type`);
      }
    }));
  };
}