"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Queue = Queue;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _statement_list_heading = require("./statement_list_heading");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const queueMessageStyle = ({
  euiTheme
}) => (0, _react2.css)`
  ${(0, _eui.logicalCSS)('margin-left', euiTheme.size.l)}
  color: ${euiTheme.colors.darkShade};
`;
function Queue() {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_statement_list_heading.StatementListHeading, {
    iconType: "logstashQueue",
    title: "Queue"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: queueMessageStyle
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.queue.noMetricsDescription",
    defaultMessage: "Queue metrics not available"
  })));
}