"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldOverrideRefreshInterval = void 0;
var _public = require("@kbn/data-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const shouldOverrideRefreshInterval = (uiSettings, timefilter) => {
  const isUserDefined = timefilter.isRefreshIntervalTouched() || !uiSettings.isDefault(_public.UI_SETTINGS.TIMEPICKER_REFRESH_INTERVAL_DEFAULTS);
  if (isUserDefined) {
    return false;
  }
  const currentInterval = timefilter.getRefreshInterval();
  const isPaused = currentInterval.pause || currentInterval.value === 0;
  return isPaused;
};
exports.shouldOverrideRefreshInterval = shouldOverrideRefreshInterval;