"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.offsetToRowColumn = offsetToRowColumn;
exports.wrapAsMonacoMessages = wrapAsMonacoMessages;
var _monaco_imports = require("../../../../monaco_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// from linear offset to Monaco position
function offsetToRowColumn(expression, offset) {
  const lines = expression.split(/\n/);
  let remainingChars = offset;
  let lineNumber = 1;
  for (const line of lines) {
    if (line.length >= remainingChars) {
      return new _monaco_imports.monaco.Position(lineNumber, remainingChars + 1);
    }
    remainingChars -= line.length + 1;
    lineNumber++;
  }
  throw new Error('Algorithm failure');
}
function convertSeverityToMonacoKind(severity) {
  if (typeof severity === 'number') return severity;
  return severity === 'error' ? _monaco_imports.monaco.MarkerSeverity.Error : _monaco_imports.monaco.MarkerSeverity.Warning;
}
function wrapAsMonacoMessages(queryString, messages) {
  const fallbackPosition = {
    column: 0,
    lineNumber: 0
  };
  return messages.map(e => {
    if ('severity' in e) {
      return {
        ...e,
        severity: convertSeverityToMonacoKind(e.severity)
      };
    }
    const startPosition = e.location ? offsetToRowColumn(queryString, e.location.min) : fallbackPosition;
    const endPosition = e.location ? offsetToRowColumn(queryString, e.location.max || 0) : fallbackPosition;
    return {
      message: e.text,
      startColumn: startPosition.column,
      startLineNumber: startPosition.lineNumber,
      endColumn: endPosition.column + 1,
      endLineNumber: endPosition.lineNumber,
      severity: convertSeverityToMonacoKind(e.type),
      _source: 'client',
      code: e.code
    };
  });
}